/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.support;

import com.couchbase.client.java.query.QueryScanConsistency;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.core.CouchbaseTemplate;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.couchbase.repository.CouchbaseRepository;
import org.springframework.data.couchbase.repository.query.CouchbaseEntityInformation;
import org.springframework.data.couchbase.repository.support.CouchbaseRepositoryBase;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.util.StreamUtils;
import org.springframework.data.util.Streamable;
import org.springframework.util.Assert;

public class SimpleCouchbaseRepository<T, ID>
extends CouchbaseRepositoryBase<T, ID>
implements CouchbaseRepository<T, ID> {
    private final CouchbaseOperations operations;

    public SimpleCouchbaseRepository(CouchbaseEntityInformation<T, String> entityInformation, CouchbaseOperations couchbaseOperations, Class<?> repositoryInterface) {
        super(entityInformation, repositoryInterface);
        this.operations = couchbaseOperations;
    }

    public <S extends T> S save(S entity) {
        String scopeName = this.getScope();
        String collectionName = this.getCollection();
        this.getReactiveTemplate().setPseudoArgs(null);
        return this.operations.save(entity, scopeName, collectionName);
    }

    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        return (Iterable)Streamable.of(entities).stream().map(e -> this.save(e)).collect(StreamUtils.toUnmodifiableList());
    }

    public Optional<T> findById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return Optional.ofNullable(this.operations.findById(this.getJavaType()).inScope(this.getScope()).inCollection(this.getCollection()).one(id.toString()));
    }

    @Override
    public List<T> findAllById(Iterable<ID> ids) {
        Assert.notNull(ids, (String)"The given Iterable of ids must not be null!");
        List<String> convertedIds = Streamable.of(ids).stream().map(Objects::toString).collect(Collectors.toList());
        Collection all = this.operations.findById(this.getJavaType()).inScope(this.getScope()).inCollection(this.getCollection()).all(convertedIds);
        return (List)Streamable.of(all).stream().collect(StreamUtils.toUnmodifiableList());
    }

    public boolean existsById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.operations.existsById(this.getJavaType()).inScope(this.getScope()).inCollection(this.getCollection()).one(id.toString());
    }

    public void deleteById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        this.operations.removeById(this.getJavaType()).inScope(this.getScope()).inCollection(this.getCollection()).one(id.toString());
    }

    public void delete(T entity) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        this.operations.removeById(this.getJavaType()).inScope(this.getScope()).inCollection(this.getCollection()).oneEntity(entity);
    }

    public void deleteAllById(Iterable<? extends ID> ids) {
        Assert.notNull(ids, (String)"The given Iterable of ids must not be null!");
        this.operations.removeById(this.getJavaType()).inScope(this.getScope()).inCollection(this.getCollection()).all((Collection)Streamable.of(ids).map(Objects::toString).toList());
    }

    public void deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        this.operations.removeById(this.getJavaType()).inScope(this.getScope()).inCollection(this.getCollection()).allEntities(Streamable.of(entities).toList());
    }

    public long count() {
        return this.operations.findByQuery(this.getJavaType()).withConsistency(this.getQueryScanConsistency()).inScope(this.getScope()).inCollection(this.getCollection()).count();
    }

    public void deleteAll() {
        this.operations.removeByQuery(this.getJavaType()).withConsistency(this.getQueryScanConsistency()).inScope(this.getScope()).inCollection(this.getCollection()).all();
    }

    @Override
    public List<T> findAll() {
        return this.findAll(new Query());
    }

    @Override
    public List<T> findAll(Sort sort) {
        return this.findAll(new Query().with(sort));
    }

    @Override
    public List<T> findAll(QueryScanConsistency queryScanConsistency) {
        return this.findAll(new Query().scanConsistency(queryScanConsistency));
    }

    public Page<T> findAll(Pageable pageable) {
        List<T> results = this.findAll(new Query().with(pageable));
        return new PageImpl(results, pageable, this.count());
    }

    private List<T> findAll(Query query) {
        return this.operations.findByQuery(this.getJavaType()).withConsistency(this.getQueryScanConsistency()).inScope(this.getScope()).inCollection(this.getCollection()).matching(query).all();
    }

    @Override
    public CouchbaseOperations getOperations() {
        return this.operations;
    }

    @Override
    protected ReactiveCouchbaseTemplate getReactiveTemplate() {
        return ((CouchbaseTemplate)this.getOperations()).reactive();
    }
}

