/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.NodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.ClassPathResource;

public class NodeClientFactoryBean
implements FactoryBean<NodeClient>,
InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(NodeClientFactoryBean.class);
    private boolean local;
    private boolean enableHttp;
    private String clusterName;
    private NodeClient nodeClient;
    private String pathData;
    private String pathConfiguration;

    NodeClientFactoryBean() {
    }

    public NodeClientFactoryBean(boolean local) {
        this.local = local;
    }

    public NodeClient getObject() throws Exception {
        return this.nodeClient;
    }

    public Class<? extends Client> getObjectType() {
        return NodeClient.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        ImmutableSettings.Builder settings = ImmutableSettings.settingsBuilder().put(this.loadConfig()).put("http.enabled", String.valueOf(this.enableHttp)).put("path.data", this.pathData);
        this.nodeClient = (NodeClient)NodeBuilder.nodeBuilder().settings((Settings.Builder)settings).clusterName(this.clusterName).local(this.local).node().client();
    }

    private Settings loadConfig() {
        if (StringUtils.isNotBlank((String)this.pathConfiguration)) {
            try {
                return ImmutableSettings.builder().loadFromUrl(new ClassPathResource(this.pathConfiguration).getURL()).build();
            }
            catch (IOException e) {
                logger.error(String.format("Unable to read node configuration from file [%s]", this.pathConfiguration), (Throwable)e);
            }
        }
        return ImmutableSettings.builder().build();
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    public void setEnableHttp(boolean enableHttp) {
        this.enableHttp = enableHttp;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setPathData(String pathData) {
        this.pathData = pathData;
    }

    public void setPathConfiguration(String configuration) {
        this.pathConfiguration = configuration;
    }

    public void destroy() throws Exception {
        try {
            logger.info("Closing elasticSearch  client");
            if (this.nodeClient != null) {
                this.nodeClient.close();
            }
        }
        catch (Exception e) {
            logger.error("Error closing ElasticSearch client: ", (Throwable)e);
        }
    }
}

