/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.facet.FacetRequest;
import org.springframework.data.elasticsearch.core.query.IndexBoost;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.ScriptField;
import org.springframework.data.elasticsearch.core.query.SourceFilter;
import org.springframework.util.CollectionUtils;

public class NativeSearchQueryBuilder {
    private QueryBuilder queryBuilder;
    private QueryBuilder filterBuilder;
    private List<ScriptField> scriptFields = new ArrayList<ScriptField>();
    private List<SortBuilder> sortBuilders = new ArrayList<SortBuilder>();
    private List<FacetRequest> facetRequests = new ArrayList<FacetRequest>();
    private List<AbstractAggregationBuilder> aggregationBuilders = new ArrayList<AbstractAggregationBuilder>();
    private HighlightBuilder.Field[] highlightFields;
    private Pageable pageable = Pageable.unpaged();
    private String[] indices;
    private String[] types;
    private String[] fields;
    private SourceFilter sourceFilter;
    private List<IndexBoost> indicesBoost;
    private float minScore;
    private Collection<String> ids;
    private String route;
    private SearchType searchType;
    private IndicesOptions indicesOptions;

    public NativeSearchQueryBuilder withQuery(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
        return this;
    }

    public NativeSearchQueryBuilder withFilter(QueryBuilder filterBuilder) {
        this.filterBuilder = filterBuilder;
        return this;
    }

    public NativeSearchQueryBuilder withSort(SortBuilder sortBuilder) {
        this.sortBuilders.add(sortBuilder);
        return this;
    }

    public NativeSearchQueryBuilder withScriptField(ScriptField scriptField) {
        this.scriptFields.add(scriptField);
        return this;
    }

    public NativeSearchQueryBuilder addAggregation(AbstractAggregationBuilder aggregationBuilder) {
        this.aggregationBuilders.add(aggregationBuilder);
        return this;
    }

    public NativeSearchQueryBuilder withFacet(FacetRequest facetRequest) {
        this.facetRequests.add(facetRequest);
        return this;
    }

    public NativeSearchQueryBuilder withHighlightFields(HighlightBuilder.Field ... highlightFields) {
        this.highlightFields = highlightFields;
        return this;
    }

    public NativeSearchQueryBuilder withIndicesBoost(List<IndexBoost> indicesBoost) {
        this.indicesBoost = indicesBoost;
        return this;
    }

    public NativeSearchQueryBuilder withPageable(Pageable pageable) {
        this.pageable = pageable;
        return this;
    }

    public NativeSearchQueryBuilder withIndices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public NativeSearchQueryBuilder withTypes(String ... types) {
        this.types = types;
        return this;
    }

    public NativeSearchQueryBuilder withFields(String ... fields) {
        this.fields = fields;
        return this;
    }

    public NativeSearchQueryBuilder withSourceFilter(SourceFilter sourceFilter) {
        this.sourceFilter = sourceFilter;
        return this;
    }

    public NativeSearchQueryBuilder withMinScore(float minScore) {
        this.minScore = minScore;
        return this;
    }

    public NativeSearchQueryBuilder withIds(Collection<String> ids) {
        this.ids = ids;
        return this;
    }

    public NativeSearchQueryBuilder withRoute(String route) {
        this.route = route;
        return this;
    }

    public NativeSearchQueryBuilder withSearchType(SearchType searchType) {
        this.searchType = searchType;
        return this;
    }

    public NativeSearchQueryBuilder withIndicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public NativeSearchQuery build() {
        NativeSearchQuery nativeSearchQuery = new NativeSearchQuery(this.queryBuilder, this.filterBuilder, this.sortBuilders, this.highlightFields);
        nativeSearchQuery.setPageable(this.pageable);
        if (this.indices != null) {
            nativeSearchQuery.addIndices(this.indices);
        }
        if (this.types != null) {
            nativeSearchQuery.addTypes(this.types);
        }
        if (this.fields != null) {
            nativeSearchQuery.addFields(this.fields);
        }
        if (this.sourceFilter != null) {
            nativeSearchQuery.addSourceFilter(this.sourceFilter);
        }
        if (this.indicesBoost != null) {
            nativeSearchQuery.setIndicesBoost(this.indicesBoost);
        }
        if (!CollectionUtils.isEmpty(this.scriptFields)) {
            nativeSearchQuery.setScriptFields(this.scriptFields);
        }
        if (!CollectionUtils.isEmpty(this.facetRequests)) {
            nativeSearchQuery.setFacets(this.facetRequests);
        }
        if (!CollectionUtils.isEmpty(this.aggregationBuilders)) {
            nativeSearchQuery.setAggregations(this.aggregationBuilders);
        }
        if (this.minScore > 0.0f) {
            nativeSearchQuery.setMinScore(this.minScore);
        }
        if (this.ids != null) {
            nativeSearchQuery.setIds((Collection)this.ids);
        }
        if (this.route != null) {
            nativeSearchQuery.setRoute(this.route);
        }
        if (this.searchType != null) {
            nativeSearchQuery.setSearchType(this.searchType);
        }
        if (this.indicesOptions != null) {
            nativeSearchQuery.setIndicesOptions(this.indicesOptions);
        }
        return nativeSearchQuery;
    }
}

