/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequestBuilder;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetRequestBuilder;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.query.MoreLikeThisQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.ScoreSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.search.suggest.SuggestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.ElasticsearchException;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Mapping;
import org.springframework.data.elasticsearch.annotations.Setting;
import org.springframework.data.elasticsearch.core.CriteriaFilterProcessor;
import org.springframework.data.elasticsearch.core.CriteriaQueryProcessor;
import org.springframework.data.elasticsearch.core.DefaultResultMapper;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.EntityMapper;
import org.springframework.data.elasticsearch.core.EsClient;
import org.springframework.data.elasticsearch.core.GetResultMapper;
import org.springframework.data.elasticsearch.core.MappingBuilder;
import org.springframework.data.elasticsearch.core.MultiGetResultMapper;
import org.springframework.data.elasticsearch.core.ResultsExtractor;
import org.springframework.data.elasticsearch.core.ResultsMapper;
import org.springframework.data.elasticsearch.core.ScrolledPage;
import org.springframework.data.elasticsearch.core.SearchResultMapper;
import org.springframework.data.elasticsearch.core.SearchResultMapperAdapter;
import org.springframework.data.elasticsearch.core.aggregation.AggregatedPage;
import org.springframework.data.elasticsearch.core.aggregation.impl.AggregatedPageImpl;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.convert.MappingElasticsearchConverter;
import org.springframework.data.elasticsearch.core.facet.FacetRequest;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.mapping.SimpleElasticsearchMappingContext;
import org.springframework.data.elasticsearch.core.query.AliasQuery;
import org.springframework.data.elasticsearch.core.query.CriteriaQuery;
import org.springframework.data.elasticsearch.core.query.DeleteQuery;
import org.springframework.data.elasticsearch.core.query.FetchSourceFilter;
import org.springframework.data.elasticsearch.core.query.GetQuery;
import org.springframework.data.elasticsearch.core.query.IndexBoost;
import org.springframework.data.elasticsearch.core.query.IndexQuery;
import org.springframework.data.elasticsearch.core.query.MoreLikeThisQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.ScriptField;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.data.elasticsearch.core.query.SourceFilter;
import org.springframework.data.elasticsearch.core.query.StringQuery;
import org.springframework.data.elasticsearch.core.query.UpdateQuery;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.util.CloseableIterator;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ElasticsearchTemplate
implements ElasticsearchOperations,
EsClient<Client>,
ApplicationContextAware {
    private static final Logger QUERY_LOGGER = LoggerFactory.getLogger((String)"org.springframework.data.elasticsearch.core.QUERY");
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchTemplate.class);
    private static final String FIELD_SCORE = "_score";
    private Client client;
    private ElasticsearchConverter elasticsearchConverter;
    private ResultsMapper resultsMapper;
    private String searchTimeout;

    public ElasticsearchTemplate(Client client) {
        this(client, new MappingElasticsearchConverter((MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty>)new SimpleElasticsearchMappingContext()));
    }

    public ElasticsearchTemplate(Client client, EntityMapper entityMapper) {
        this(client, (ElasticsearchConverter)new MappingElasticsearchConverter((MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty>)new SimpleElasticsearchMappingContext()), entityMapper);
    }

    public ElasticsearchTemplate(Client client, ElasticsearchConverter elasticsearchConverter, EntityMapper entityMapper) {
        this(client, elasticsearchConverter, new DefaultResultMapper(elasticsearchConverter.getMappingContext(), entityMapper));
    }

    public ElasticsearchTemplate(Client client, ResultsMapper resultsMapper) {
        this(client, (ElasticsearchConverter)new MappingElasticsearchConverter((MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty>)new SimpleElasticsearchMappingContext()), resultsMapper);
    }

    public ElasticsearchTemplate(Client client, ElasticsearchConverter elasticsearchConverter) {
        this(client, elasticsearchConverter, new DefaultResultMapper(elasticsearchConverter.getMappingContext()));
    }

    public ElasticsearchTemplate(Client client, ElasticsearchConverter elasticsearchConverter, ResultsMapper resultsMapper) {
        Assert.notNull((Object)client, (String)"Client must not be null!");
        Assert.notNull((Object)elasticsearchConverter, (String)"ElasticsearchConverter must not be null!");
        Assert.notNull((Object)resultsMapper, (String)"ResultsMapper must not be null!");
        this.client = client;
        this.elasticsearchConverter = elasticsearchConverter;
        this.resultsMapper = resultsMapper;
    }

    @Override
    public Client getClient() {
        return this.client;
    }

    public void setSearchTimeout(String searchTimeout) {
        this.searchTimeout = searchTimeout;
    }

    @Override
    public <T> boolean createIndex(Class<T> clazz) {
        return this.createIndexIfNotCreated(clazz);
    }

    @Override
    public boolean createIndex(String indexName) {
        Assert.notNull((Object)indexName, (String)"No index defined for Query");
        return ((CreateIndexResponse)this.client.admin().indices().create(Requests.createIndexRequest((String)indexName)).actionGet()).isAcknowledged();
    }

    @Override
    public <T> boolean putMapping(Class<T> clazz) {
        if (clazz.isAnnotationPresent(Mapping.class)) {
            String mappingPath = clazz.getAnnotation(Mapping.class).mappingPath();
            if (!StringUtils.isEmpty((Object)mappingPath)) {
                String mappings = ElasticsearchTemplate.readFileFromClasspath(mappingPath);
                if (!StringUtils.isEmpty((Object)mappings)) {
                    return this.putMapping(clazz, mappings);
                }
            } else {
                LOGGER.info("mappingPath in @Mapping has to be defined. Building mappings using @Field");
            }
        }
        ElasticsearchPersistentEntity persistentEntity = this.getPersistentEntityFor(clazz);
        XContentBuilder xContentBuilder = null;
        try {
            ElasticsearchPersistentProperty property = (ElasticsearchPersistentProperty)persistentEntity.getRequiredIdProperty();
            xContentBuilder = MappingBuilder.buildMapping(clazz, persistentEntity.getIndexType(), property.getFieldName(), persistentEntity.getParentType());
        }
        catch (Exception e) {
            throw new ElasticsearchException("Failed to build mapping for " + clazz.getSimpleName(), e);
        }
        return this.putMapping(clazz, xContentBuilder);
    }

    @Override
    public <T> boolean putMapping(Class<T> clazz, Object mapping) {
        return this.putMapping(this.getPersistentEntityFor(clazz).getIndexName(), this.getPersistentEntityFor(clazz).getIndexType(), mapping);
    }

    @Override
    public boolean putMapping(String indexName, String type, Object mapping) {
        Assert.notNull((Object)indexName, (String)"No index defined for putMapping()");
        Assert.notNull((Object)type, (String)"No type defined for putMapping()");
        PutMappingRequestBuilder requestBuilder = this.client.admin().indices().preparePutMapping(new String[]{indexName}).setType(type);
        if (mapping instanceof String) {
            requestBuilder.setSource(String.valueOf(mapping), XContentType.JSON);
        } else if (mapping instanceof Map) {
            requestBuilder.setSource((Map)mapping);
        } else if (mapping instanceof XContentBuilder) {
            requestBuilder.setSource((XContentBuilder)mapping);
        }
        return ((AcknowledgedResponse)requestBuilder.execute().actionGet()).isAcknowledged();
    }

    @Override
    public Map getMapping(String indexName, String type) {
        Assert.notNull((Object)indexName, (String)"No index defined for putMapping()");
        Assert.notNull((Object)type, (String)"No type defined for putMapping()");
        Map mappings = null;
        try {
            mappings = ((MappingMetaData)((ImmutableOpenMap)((GetMappingsResponse)this.client.admin().indices().getMappings((GetMappingsRequest)((GetMappingsRequest)new GetMappingsRequest().indices(new String[]{indexName})).types(new String[]{type})).actionGet()).getMappings().get((Object)indexName)).get((Object)type)).getSourceAsMap();
        }
        catch (Exception e) {
            throw new ElasticsearchException("Error while getting mapping for indexName : " + indexName + " type : " + type + " " + e.getMessage());
        }
        return mappings;
    }

    @Override
    public <T> Map getMapping(Class<T> clazz) {
        return this.getMapping(this.getPersistentEntityFor(clazz).getIndexName(), this.getPersistentEntityFor(clazz).getIndexType());
    }

    @Override
    public ElasticsearchConverter getElasticsearchConverter() {
        return this.elasticsearchConverter;
    }

    @Override
    public <T> T queryForObject(GetQuery query, Class<T> clazz) {
        return this.queryForObject(query, clazz, this.resultsMapper);
    }

    @Override
    public <T> T queryForObject(GetQuery query, Class<T> clazz, GetResultMapper mapper) {
        ElasticsearchPersistentEntity persistentEntity = this.getPersistentEntityFor(clazz);
        GetResponse response = (GetResponse)this.client.prepareGet(persistentEntity.getIndexName(), persistentEntity.getIndexType(), query.getId()).execute().actionGet();
        T entity = mapper.mapResult(response, clazz);
        return entity;
    }

    @Override
    public <T> T queryForObject(CriteriaQuery query, Class<T> clazz) {
        Page<T> page = this.queryForPage(query, clazz);
        Assert.isTrue((page.getTotalElements() < 2L ? 1 : 0) != 0, (String)("Expected 1 but found " + page.getTotalElements() + " results"));
        return page.getTotalElements() > 0L ? (T)page.getContent().get(0) : null;
    }

    @Override
    public <T> T queryForObject(StringQuery query, Class<T> clazz) {
        Page<T> page = this.queryForPage(query, clazz);
        Assert.isTrue((page.getTotalElements() < 2L ? 1 : 0) != 0, (String)("Expected 1 but found " + page.getTotalElements() + " results"));
        return page.getTotalElements() > 0L ? (T)page.getContent().get(0) : null;
    }

    public <T> AggregatedPage<T> queryForPage(SearchQuery query, Class<T> clazz) {
        return this.queryForPage(query, (Class)clazz, (SearchResultMapper)this.resultsMapper);
    }

    public <T> AggregatedPage<T> queryForPage(SearchQuery query, Class<T> clazz, SearchResultMapper mapper) {
        SearchResponse response = this.doSearch(this.prepareSearch(query, clazz), query);
        return mapper.mapResults(response, clazz, query.getPageable());
    }

    @Override
    public <T> List<Page<T>> queryForPage(List<SearchQuery> queries, Class<T> clazz) {
        return this.queryForPage(queries, clazz, (SearchResultMapper)this.resultsMapper);
    }

    @Override
    public <T> List<Page<T>> queryForPage(List<SearchQuery> queries, Class<T> clazz, SearchResultMapper mapper) {
        MultiSearchRequest request = new MultiSearchRequest();
        for (SearchQuery query : queries) {
            request.add(this.prepareSearch(this.prepareSearch(query, clazz), query));
        }
        return this.doMultiSearch(queries, clazz, request, mapper);
    }

    private <T> List<Page<T>> doMultiSearch(List<SearchQuery> queries, Class<T> clazz, MultiSearchRequest request, SearchResultMapper resultsMapper) {
        MultiSearchResponse.Item[] items = this.getMultiSearchResult(request);
        ArrayList<Page<T>> res = new ArrayList<Page<T>>(queries.size());
        int c = 0;
        for (SearchQuery query : queries) {
            res.add(resultsMapper.mapResults(items[c++].getResponse(), clazz, query.getPageable()));
        }
        return res;
    }

    private List<Page<?>> doMultiSearch(List<SearchQuery> queries, List<Class<?>> classes, MultiSearchRequest request, SearchResultMapper resultsMapper) {
        MultiSearchResponse.Item[] items = this.getMultiSearchResult(request);
        ArrayList res = new ArrayList(queries.size());
        int c = 0;
        Iterator<Class<?>> it = classes.iterator();
        for (SearchQuery query : queries) {
            res.add(resultsMapper.mapResults(items[c++].getResponse(), it.next(), query.getPageable()));
        }
        return res;
    }

    private MultiSearchResponse.Item[] getMultiSearchResult(MultiSearchRequest request) {
        ActionFuture future = this.client.multiSearch(request);
        MultiSearchResponse response = (MultiSearchResponse)future.actionGet();
        MultiSearchResponse.Item[] items = response.getResponses();
        Assert.isTrue((items.length == request.requests().size() ? 1 : 0) != 0, (String)"Response should have same length with queries");
        return items;
    }

    @Override
    public List<Page<?>> queryForPage(List<SearchQuery> queries, List<Class<?>> classes) {
        return this.queryForPage(queries, classes, (SearchResultMapper)this.resultsMapper);
    }

    @Override
    public List<Page<?>> queryForPage(List<SearchQuery> queries, List<Class<?>> classes, SearchResultMapper mapper) {
        Assert.isTrue((queries.size() == classes.size() ? 1 : 0) != 0, (String)"Queries should have same length with classes");
        MultiSearchRequest request = new MultiSearchRequest();
        Iterator<Class<?>> it = classes.iterator();
        for (SearchQuery query : queries) {
            request.add(this.prepareSearch(this.prepareSearch(query, it.next()), query));
        }
        return this.doMultiSearch(queries, classes, request, mapper);
    }

    @Override
    public <T> T query(SearchQuery query, ResultsExtractor<T> resultsExtractor) {
        SearchResponse response = this.doSearch(this.prepareSearch(query), query);
        return resultsExtractor.extract(response);
    }

    @Override
    public <T> List<T> queryForList(CriteriaQuery query, Class<T> clazz) {
        return this.queryForPage(query, clazz).getContent();
    }

    @Override
    public <T> List<T> queryForList(StringQuery query, Class<T> clazz) {
        return this.queryForPage(query, clazz).getContent();
    }

    @Override
    public <T> List<T> queryForList(SearchQuery query, Class<T> clazz) {
        return this.queryForPage(query, (Class)clazz).getContent();
    }

    @Override
    public <T> List<String> queryForIds(SearchQuery query) {
        SearchRequestBuilder request = this.prepareSearch(query).setQuery(query.getQuery());
        if (query.getFilter() != null) {
            request.setPostFilter(query.getFilter());
        }
        SearchResponse response = this.getSearchResponse(request);
        return this.extractIds(response);
    }

    @Override
    public <T> Page<T> queryForPage(CriteriaQuery criteriaQuery, Class<T> clazz) {
        QueryBuilder elasticsearchQuery = new CriteriaQueryProcessor().createQueryFromCriteria(criteriaQuery.getCriteria());
        QueryBuilder elasticsearchFilter = new CriteriaFilterProcessor().createFilterFromCriteria(criteriaQuery.getCriteria());
        SearchRequestBuilder searchRequestBuilder = this.prepareSearch(criteriaQuery, clazz);
        if (elasticsearchQuery != null) {
            searchRequestBuilder.setQuery(elasticsearchQuery);
        } else {
            searchRequestBuilder.setQuery((QueryBuilder)QueryBuilders.matchAllQuery());
        }
        if (criteriaQuery.getMinScore() > 0.0f) {
            searchRequestBuilder.setMinScore(criteriaQuery.getMinScore());
        }
        if (elasticsearchFilter != null) {
            searchRequestBuilder.setPostFilter(elasticsearchFilter);
        }
        SearchResponse response = this.getSearchResponse(searchRequestBuilder);
        return this.resultsMapper.mapResults(response, clazz, criteriaQuery.getPageable());
    }

    @Override
    public <T> Page<T> queryForPage(StringQuery query, Class<T> clazz) {
        return this.queryForPage(query, clazz, (SearchResultMapper)this.resultsMapper);
    }

    @Override
    public <T> Page<T> queryForPage(StringQuery query, Class<T> clazz, SearchResultMapper mapper) {
        SearchResponse response = this.getSearchResponse(this.prepareSearch(query, clazz).setQuery((QueryBuilder)QueryBuilders.wrapperQuery((String)query.getSource())));
        return mapper.mapResults(response, clazz, query.getPageable());
    }

    @Override
    public <T> CloseableIterator<T> stream(CriteriaQuery query, Class<T> clazz) {
        long scrollTimeInMillis = TimeValue.timeValueMinutes((long)1L).millis();
        return this.doStream(scrollTimeInMillis, (ScrolledPage)this.startScroll(scrollTimeInMillis, query, clazz), clazz, this.resultsMapper);
    }

    @Override
    public <T> CloseableIterator<T> stream(SearchQuery query, Class<T> clazz) {
        return this.stream(query, clazz, this.resultsMapper);
    }

    @Override
    public <T> CloseableIterator<T> stream(SearchQuery query, Class<T> clazz, SearchResultMapper mapper) {
        long scrollTimeInMillis = TimeValue.timeValueMinutes((long)1L).millis();
        return this.doStream(scrollTimeInMillis, (ScrolledPage)this.startScroll(scrollTimeInMillis, query, clazz, mapper), clazz, mapper);
    }

    private <T> CloseableIterator<T> doStream(final long scrollTimeInMillis, final ScrolledPage<T> page, final Class<T> clazz, final SearchResultMapper mapper) {
        return new CloseableIterator<T>(){
            private volatile Iterator<T> currentHits;
            private volatile String scrollId;
            private volatile boolean finished;
            {
                this.currentHits = page.iterator();
                this.scrollId = page.getScrollId();
                this.finished = !this.currentHits.hasNext();
            }

            public void close() {
                try {
                    if (!this.finished && this.scrollId != null && this.currentHits != null && this.currentHits.hasNext()) {
                        ElasticsearchTemplate.this.clearScroll(this.scrollId);
                    }
                }
                finally {
                    this.currentHits = null;
                    this.scrollId = null;
                }
            }

            public boolean hasNext() {
                if (this.finished) {
                    return false;
                }
                if (this.currentHits == null || !this.currentHits.hasNext()) {
                    ScrolledPage scroll = (ScrolledPage)ElasticsearchTemplate.this.continueScroll(this.scrollId, scrollTimeInMillis, clazz, mapper);
                    this.currentHits = scroll.iterator();
                    this.finished = !this.currentHits.hasNext();
                    this.scrollId = scroll.getScrollId();
                }
                return this.currentHits.hasNext();
            }

            public T next() {
                if (this.hasNext()) {
                    return this.currentHits.next();
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    @Override
    public <T> long count(CriteriaQuery criteriaQuery, Class<T> clazz) {
        QueryBuilder elasticsearchQuery = new CriteriaQueryProcessor().createQueryFromCriteria(criteriaQuery.getCriteria());
        QueryBuilder elasticsearchFilter = new CriteriaFilterProcessor().createFilterFromCriteria(criteriaQuery.getCriteria());
        if (elasticsearchFilter == null) {
            return this.doCount(this.prepareCount(criteriaQuery, clazz), elasticsearchQuery);
        }
        return this.doCount(this.prepareSearch(criteriaQuery, clazz), elasticsearchQuery, elasticsearchFilter);
    }

    @Override
    public <T> long count(SearchQuery searchQuery, Class<T> clazz) {
        QueryBuilder elasticsearchQuery = searchQuery.getQuery();
        QueryBuilder elasticsearchFilter = searchQuery.getFilter();
        if (elasticsearchFilter == null) {
            return this.doCount(this.prepareCount(searchQuery, clazz), elasticsearchQuery);
        }
        return this.doCount(this.prepareSearch(searchQuery, clazz), elasticsearchQuery, elasticsearchFilter);
    }

    @Override
    public <T> long count(CriteriaQuery query) {
        return this.count(query, null);
    }

    @Override
    public <T> long count(SearchQuery query) {
        return this.count(query, null);
    }

    private long doCount(SearchRequestBuilder countRequestBuilder, QueryBuilder elasticsearchQuery) {
        if (elasticsearchQuery != null) {
            countRequestBuilder.setQuery(elasticsearchQuery);
        }
        return ((SearchResponse)countRequestBuilder.execute().actionGet()).getHits().getTotalHits();
    }

    private long doCount(SearchRequestBuilder searchRequestBuilder, QueryBuilder elasticsearchQuery, QueryBuilder elasticsearchFilter) {
        if (elasticsearchQuery != null) {
            searchRequestBuilder.setQuery(elasticsearchQuery);
        } else {
            searchRequestBuilder.setQuery((QueryBuilder)QueryBuilders.matchAllQuery());
        }
        if (elasticsearchFilter != null) {
            searchRequestBuilder.setPostFilter(elasticsearchFilter);
        }
        return ((SearchResponse)searchRequestBuilder.execute().actionGet()).getHits().getTotalHits();
    }

    private <T> SearchRequestBuilder prepareCount(Query query, Class<T> clazz) {
        String[] indexName = !CollectionUtils.isEmpty(query.getIndices()) ? query.getIndices().toArray(new String[query.getIndices().size()]) : this.retrieveIndexNameFromPersistentEntity(clazz);
        String[] types = !CollectionUtils.isEmpty(query.getTypes()) ? query.getTypes().toArray(new String[query.getTypes().size()]) : this.retrieveTypeFromPersistentEntity(clazz);
        Assert.notNull((Object)indexName, (String)"No index defined for Query");
        SearchRequestBuilder countRequestBuilder = this.client.prepareSearch(indexName);
        if (types != null) {
            countRequestBuilder.setTypes(types);
        }
        countRequestBuilder.setSize(0);
        return countRequestBuilder;
    }

    @Override
    public <T> LinkedList<T> multiGet(SearchQuery searchQuery, Class<T> clazz) {
        return this.resultsMapper.mapResults(this.getMultiResponse(searchQuery, clazz), clazz);
    }

    private <T> MultiGetResponse getMultiResponse(Query searchQuery, Class<T> clazz) {
        String indexName = !CollectionUtils.isEmpty(searchQuery.getIndices()) ? searchQuery.getIndices().get(0) : this.getPersistentEntityFor(clazz).getIndexName();
        String type = !CollectionUtils.isEmpty(searchQuery.getTypes()) ? searchQuery.getTypes().get(0) : this.getPersistentEntityFor(clazz).getIndexType();
        Assert.notNull((Object)indexName, (String)"No index defined for Query");
        Assert.notNull((Object)type, (String)"No type define for Query");
        Assert.notEmpty(searchQuery.getIds(), (String)"No Id define for Query");
        MultiGetRequestBuilder builder = this.client.prepareMultiGet();
        if (searchQuery.getFields() != null && !searchQuery.getFields().isEmpty()) {
            searchQuery.addSourceFilter(new FetchSourceFilter(ElasticsearchTemplate.toArray(searchQuery.getFields()), null));
        }
        for (String id : searchQuery.getIds()) {
            MultiGetRequest.Item item = new MultiGetRequest.Item(indexName, type, id);
            if (searchQuery.getRoute() != null) {
                item = item.routing(searchQuery.getRoute());
            }
            builder.add(item);
        }
        return (MultiGetResponse)builder.execute().actionGet();
    }

    @Override
    public <T> LinkedList<T> multiGet(SearchQuery searchQuery, Class<T> clazz, MultiGetResultMapper getResultMapper) {
        return getResultMapper.mapResults(this.getMultiResponse(searchQuery, clazz), clazz);
    }

    @Override
    public String index(IndexQuery query) {
        String documentId = ((IndexResponse)this.prepareIndex(query).execute().actionGet()).getId();
        if (query.getObject() != null) {
            this.setPersistentEntityId(query.getObject(), documentId);
        }
        return documentId;
    }

    @Override
    public UpdateResponse update(UpdateQuery query) {
        return (UpdateResponse)this.prepareUpdate(query).execute().actionGet();
    }

    private UpdateRequestBuilder prepareUpdate(UpdateQuery query) {
        String indexName = !StringUtils.isEmpty((Object)query.getIndexName()) ? query.getIndexName() : this.getPersistentEntityFor(query.getClazz()).getIndexName();
        String type = !StringUtils.isEmpty((Object)query.getType()) ? query.getType() : this.getPersistentEntityFor(query.getClazz()).getIndexType();
        Assert.notNull((Object)indexName, (String)"No index defined for Query");
        Assert.notNull((Object)type, (String)"No type define for Query");
        Assert.notNull((Object)query.getId(), (String)"No Id define for Query");
        Assert.notNull((Object)query.getUpdateRequest(), (String)"No IndexRequest define for Query");
        UpdateRequestBuilder updateRequestBuilder = this.client.prepareUpdate(indexName, type, query.getId());
        updateRequestBuilder.setRouting(query.getUpdateRequest().routing());
        if (query.getUpdateRequest().script() == null) {
            if (query.DoUpsert()) {
                updateRequestBuilder.setDocAsUpsert(true).setDoc(query.getUpdateRequest().doc());
            } else {
                updateRequestBuilder.setDoc(query.getUpdateRequest().doc());
            }
        } else {
            updateRequestBuilder.setScript(query.getUpdateRequest().script());
        }
        return updateRequestBuilder;
    }

    @Override
    public void bulkIndex(List<IndexQuery> queries) {
        BulkRequestBuilder bulkRequest = this.client.prepareBulk();
        for (IndexQuery query : queries) {
            bulkRequest.add(this.prepareIndex(query));
        }
        this.checkForBulkUpdateFailure((BulkResponse)bulkRequest.execute().actionGet());
    }

    @Override
    public void bulkUpdate(List<UpdateQuery> queries) {
        BulkRequestBuilder bulkRequest = this.client.prepareBulk();
        for (UpdateQuery query : queries) {
            bulkRequest.add(this.prepareUpdate(query));
        }
        this.checkForBulkUpdateFailure((BulkResponse)bulkRequest.execute().actionGet());
    }

    private void checkForBulkUpdateFailure(BulkResponse bulkResponse) {
        if (bulkResponse.hasFailures()) {
            HashMap<String, String> failedDocuments = new HashMap<String, String>();
            for (BulkItemResponse item : bulkResponse.getItems()) {
                if (!item.isFailed()) continue;
                failedDocuments.put(item.getId(), item.getFailureMessage());
            }
            throw new ElasticsearchException("Bulk indexing has failures. Use ElasticsearchException.getFailedDocuments() for detailed messages [" + failedDocuments + "]", failedDocuments);
        }
    }

    @Override
    public <T> boolean indexExists(Class<T> clazz) {
        return this.indexExists(this.getPersistentEntityFor(clazz).getIndexName());
    }

    @Override
    public boolean indexExists(String indexName) {
        return ((IndicesExistsResponse)this.client.admin().indices().exists(Requests.indicesExistsRequest((String[])new String[]{indexName})).actionGet()).isExists();
    }

    @Override
    public boolean typeExists(String index, String type) {
        return ((ClusterStateResponse)this.client.admin().cluster().prepareState().execute().actionGet()).getState().metaData().index(index).getMappings().containsKey((Object)type);
    }

    @Override
    public <T> boolean deleteIndex(Class<T> clazz) {
        return this.deleteIndex(this.getPersistentEntityFor(clazz).getIndexName());
    }

    @Override
    public boolean deleteIndex(String indexName) {
        Assert.notNull((Object)indexName, (String)"No index defined for delete operation");
        if (this.indexExists(indexName)) {
            return ((AcknowledgedResponse)this.client.admin().indices().delete(new DeleteIndexRequest(indexName)).actionGet()).isAcknowledged();
        }
        return false;
    }

    @Override
    public String delete(String indexName, String type, String id) {
        return ((DeleteResponse)this.client.prepareDelete(indexName, type, id).execute().actionGet()).getId();
    }

    @Override
    public <T> String delete(Class<T> clazz, String id) {
        ElasticsearchPersistentEntity persistentEntity = this.getPersistentEntityFor(clazz);
        return this.delete(persistentEntity.getIndexName(), persistentEntity.getIndexType(), id);
    }

    @Override
    public <T> void delete(DeleteQuery deleteQuery, Class<T> clazz) {
        String indexName = !StringUtils.isEmpty((Object)deleteQuery.getIndex()) ? deleteQuery.getIndex() : this.getPersistentEntityFor(clazz).getIndexName();
        String typeName = !StringUtils.isEmpty((Object)deleteQuery.getType()) ? deleteQuery.getType() : this.getPersistentEntityFor(clazz).getIndexType();
        Integer pageSize = deleteQuery.getPageSize() != null ? deleteQuery.getPageSize() : 1000;
        Long scrollTimeInMillis = deleteQuery.getScrollTimeInMillis() != null ? deleteQuery.getScrollTimeInMillis() : 10000L;
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery(deleteQuery.getQuery()).withIndices(indexName).withTypes(typeName).withPageable((Pageable)PageRequest.of((int)0, (int)pageSize)).build();
        SearchResultMapperAdapter deleteEntryResultMapper = new SearchResultMapperAdapter(){

            @Override
            public <T> AggregatedPage<T> mapResults(SearchResponse response, Class<T> clazz, Pageable pageable) {
                return new AggregatedPageImpl<SearchHit>(Arrays.asList(response.getHits().getHits()), response.getScrollId());
            }
        };
        Page<SearchHit> scrolledResult = this.startScroll((long)scrollTimeInMillis, searchQuery, SearchHit.class, (SearchResultMapper)deleteEntryResultMapper);
        BulkRequestBuilder bulkRequestBuilder = this.client.prepareBulk();
        ArrayList documentsToDelete = new ArrayList();
        do {
            documentsToDelete.addAll(scrolledResult.getContent());
        } while ((scrolledResult = this.continueScroll(((ScrolledPage)scrolledResult).getScrollId(), scrollTimeInMillis, SearchHit.class, deleteEntryResultMapper)).getContent().size() != 0);
        for (SearchHit entry : documentsToDelete) {
            bulkRequestBuilder.add(this.client.prepareDelete(entry.getIndex(), typeName, entry.getId()));
        }
        if (bulkRequestBuilder.numberOfActions() > 0) {
            bulkRequestBuilder.execute().actionGet();
        }
        this.clearScroll(((ScrolledPage)scrolledResult).getScrollId());
    }

    @Override
    public void delete(DeleteQuery deleteQuery) {
        Assert.notNull((Object)deleteQuery.getIndex(), (String)"No index defined for Query");
        Assert.notNull((Object)deleteQuery.getType(), (String)"No type define for Query");
        this.delete(deleteQuery, null);
    }

    @Override
    public <T> void delete(CriteriaQuery criteriaQuery, Class<T> clazz) {
        QueryBuilder elasticsearchQuery = new CriteriaQueryProcessor().createQueryFromCriteria(criteriaQuery.getCriteria());
        Assert.notNull((Object)elasticsearchQuery, (String)"Query can not be null.");
        DeleteQuery deleteQuery = new DeleteQuery();
        deleteQuery.setQuery(elasticsearchQuery);
        this.delete(deleteQuery, clazz);
    }

    private <T> SearchRequestBuilder prepareScroll(Query query, long scrollTimeInMillis, Class<T> clazz) {
        this.setPersistentEntityIndexAndType(query, clazz);
        return this.prepareScroll(query, scrollTimeInMillis);
    }

    private SearchRequestBuilder prepareScroll(Query query, long scrollTimeInMillis) {
        SearchRequestBuilder requestBuilder = this.client.prepareSearch(ElasticsearchTemplate.toArray(query.getIndices())).setTypes(ElasticsearchTemplate.toArray(query.getTypes())).setScroll(TimeValue.timeValueMillis((long)scrollTimeInMillis)).setFrom(0).setVersion(true);
        if (query.getPageable().isPaged()) {
            requestBuilder.setSize(query.getPageable().getPageSize());
        }
        if (!CollectionUtils.isEmpty(query.getFields())) {
            requestBuilder.setFetchSource(ElasticsearchTemplate.toArray(query.getFields()), null);
        }
        return requestBuilder;
    }

    private SearchResponse doScroll(SearchRequestBuilder requestBuilder, CriteriaQuery criteriaQuery) {
        Assert.notNull((Object)criteriaQuery.getIndices(), (String)"No index defined for Query");
        Assert.notNull((Object)criteriaQuery.getTypes(), (String)"No type define for Query");
        Assert.notNull((Object)criteriaQuery.getPageable(), (String)"Query.pageable is required for scan & scroll");
        QueryBuilder elasticsearchQuery = new CriteriaQueryProcessor().createQueryFromCriteria(criteriaQuery.getCriteria());
        QueryBuilder elasticsearchFilter = new CriteriaFilterProcessor().createFilterFromCriteria(criteriaQuery.getCriteria());
        if (elasticsearchQuery != null) {
            requestBuilder.setQuery(elasticsearchQuery);
        } else {
            requestBuilder.setQuery((QueryBuilder)QueryBuilders.matchAllQuery());
        }
        if (elasticsearchFilter != null) {
            requestBuilder.setPostFilter(elasticsearchFilter);
        }
        return this.getSearchResponse(requestBuilder);
    }

    private SearchResponse doScroll(SearchRequestBuilder requestBuilder, SearchQuery searchQuery) {
        Assert.notNull(searchQuery.getIndices(), (String)"No index defined for Query");
        Assert.notNull(searchQuery.getTypes(), (String)"No type define for Query");
        Assert.notNull((Object)searchQuery.getPageable(), (String)"Query.pageable is required for scan & scroll");
        if (searchQuery.getFilter() != null) {
            requestBuilder.setPostFilter(searchQuery.getFilter());
        }
        return this.getSearchResponse(requestBuilder.setQuery(searchQuery.getQuery()));
    }

    @Override
    public <T> Page<T> startScroll(long scrollTimeInMillis, SearchQuery searchQuery, Class<T> clazz) {
        SearchResponse response = this.doScroll(this.prepareScroll(searchQuery, scrollTimeInMillis, clazz), searchQuery);
        return this.resultsMapper.mapResults(response, clazz, null);
    }

    @Override
    public <T> Page<T> startScroll(long scrollTimeInMillis, CriteriaQuery criteriaQuery, Class<T> clazz) {
        SearchResponse response = this.doScroll(this.prepareScroll(criteriaQuery, scrollTimeInMillis, clazz), criteriaQuery);
        return this.resultsMapper.mapResults(response, clazz, null);
    }

    @Override
    public <T> Page<T> startScroll(long scrollTimeInMillis, SearchQuery searchQuery, Class<T> clazz, SearchResultMapper mapper) {
        SearchResponse response = this.doScroll(this.prepareScroll(searchQuery, scrollTimeInMillis, clazz), searchQuery);
        return mapper.mapResults(response, clazz, null);
    }

    @Override
    public <T> Page<T> startScroll(long scrollTimeInMillis, CriteriaQuery criteriaQuery, Class<T> clazz, SearchResultMapper mapper) {
        SearchResponse response = this.doScroll(this.prepareScroll(criteriaQuery, scrollTimeInMillis, clazz), criteriaQuery);
        return mapper.mapResults(response, clazz, null);
    }

    @Override
    public <T> Page<T> continueScroll(@Nullable String scrollId, long scrollTimeInMillis, Class<T> clazz) {
        SearchResponse response = this.getSearchResponse((ActionFuture<SearchResponse>)this.client.prepareSearchScroll(scrollId).setScroll(TimeValue.timeValueMillis((long)scrollTimeInMillis)).execute());
        return this.resultsMapper.mapResults(response, clazz, Pageable.unpaged());
    }

    @Override
    public <T> Page<T> continueScroll(@Nullable String scrollId, long scrollTimeInMillis, Class<T> clazz, SearchResultMapper mapper) {
        SearchResponse response = this.getSearchResponse((ActionFuture<SearchResponse>)this.client.prepareSearchScroll(scrollId).setScroll(TimeValue.timeValueMillis((long)scrollTimeInMillis)).execute());
        return mapper.mapResults(response, clazz, Pageable.unpaged());
    }

    @Override
    public void clearScroll(String scrollId) {
        this.client.prepareClearScroll().addScrollId(scrollId).execute().actionGet();
    }

    @Override
    public <T> Page<T> moreLikeThis(MoreLikeThisQuery query, Class<T> clazz) {
        ElasticsearchPersistentEntity persistentEntity = this.getPersistentEntityFor(clazz);
        String indexName = !StringUtils.isEmpty((Object)query.getIndexName()) ? query.getIndexName() : persistentEntity.getIndexName();
        String type = !StringUtils.isEmpty((Object)query.getType()) ? query.getType() : persistentEntity.getIndexType();
        Assert.notNull((Object)indexName, (String)"No 'indexName' defined for MoreLikeThisQuery");
        Assert.notNull((Object)type, (String)"No 'type' defined for MoreLikeThisQuery");
        Assert.notNull((Object)query.getId(), (String)"No document id defined for MoreLikeThisQuery");
        MoreLikeThisQueryBuilder moreLikeThisQueryBuilder = QueryBuilders.moreLikeThisQuery((MoreLikeThisQueryBuilder.Item[])ElasticsearchTemplate.toArray(new MoreLikeThisQueryBuilder.Item(indexName, type, query.getId())));
        if (query.getMinTermFreq() != null) {
            moreLikeThisQueryBuilder.minTermFreq(query.getMinTermFreq().intValue());
        }
        if (query.getMaxQueryTerms() != null) {
            moreLikeThisQueryBuilder.maxQueryTerms(query.getMaxQueryTerms().intValue());
        }
        if (!CollectionUtils.isEmpty(query.getStopWords())) {
            moreLikeThisQueryBuilder.stopWords(ElasticsearchTemplate.toArray(query.getStopWords()));
        }
        if (query.getMinDocFreq() != null) {
            moreLikeThisQueryBuilder.minDocFreq(query.getMinDocFreq().intValue());
        }
        if (query.getMaxDocFreq() != null) {
            moreLikeThisQueryBuilder.maxDocFreq(query.getMaxDocFreq().intValue());
        }
        if (query.getMinWordLen() != null) {
            moreLikeThisQueryBuilder.minWordLength(query.getMinWordLen().intValue());
        }
        if (query.getMaxWordLen() != null) {
            moreLikeThisQueryBuilder.maxWordLength(query.getMaxWordLen().intValue());
        }
        if (query.getBoostTerms() != null) {
            moreLikeThisQueryBuilder.boostTerms(query.getBoostTerms().floatValue());
        }
        return this.queryForPage((SearchQuery)new NativeSearchQueryBuilder().withQuery((QueryBuilder)moreLikeThisQueryBuilder).build(), (Class)clazz);
    }

    private SearchResponse doSearch(SearchRequestBuilder searchRequest, SearchQuery searchQuery) {
        SearchRequestBuilder requestBuilder = this.prepareSearch(searchRequest, searchQuery);
        return this.getSearchResponse(requestBuilder);
    }

    private SearchRequestBuilder prepareSearch(SearchRequestBuilder searchRequest, SearchQuery searchQuery) {
        if (searchQuery.getFilter() != null) {
            searchRequest.setPostFilter(searchQuery.getFilter());
        }
        if (!CollectionUtils.isEmpty(searchQuery.getElasticsearchSorts())) {
            for (SortBuilder sortBuilder : searchQuery.getElasticsearchSorts()) {
                searchRequest.addSort(sortBuilder);
            }
        }
        if (!searchQuery.getScriptFields().isEmpty()) {
            for (ScriptField scriptField : searchQuery.getScriptFields()) {
                searchRequest.addScriptField(scriptField.fieldName(), scriptField.script());
            }
        }
        if (searchQuery.getHighlightFields() != null || searchQuery.getHighlightBuilder() != null) {
            HighlightBuilder highlightBuilder = searchQuery.getHighlightBuilder();
            if (highlightBuilder == null) {
                highlightBuilder = new HighlightBuilder();
            }
            if (searchQuery.getHighlightFields() != null) {
                for (HighlightBuilder.Field highlightField : searchQuery.getHighlightFields()) {
                    highlightBuilder.field(highlightField);
                }
            }
            searchRequest.highlighter(highlightBuilder);
        }
        if (!CollectionUtils.isEmpty(searchQuery.getIndicesBoost())) {
            for (IndexBoost indexBoost : searchQuery.getIndicesBoost()) {
                searchRequest.addIndexBoost(indexBoost.getIndexName(), indexBoost.getBoost());
            }
        }
        if (!CollectionUtils.isEmpty(searchQuery.getAggregations())) {
            for (AbstractAggregationBuilder abstractAggregationBuilder : searchQuery.getAggregations()) {
                searchRequest.addAggregation((AggregationBuilder)abstractAggregationBuilder);
            }
        }
        if (!CollectionUtils.isEmpty(searchQuery.getFacets())) {
            for (FacetRequest facetRequest : searchQuery.getFacets()) {
                searchRequest.addAggregation((AggregationBuilder)facetRequest.getFacet());
            }
        }
        return searchRequest.setQuery(searchQuery.getQuery());
    }

    private SearchResponse getSearchResponse(SearchRequestBuilder requestBuilder) {
        if (QUERY_LOGGER.isDebugEnabled()) {
            QUERY_LOGGER.debug(requestBuilder.toString());
        }
        return this.getSearchResponse((ActionFuture<SearchResponse>)requestBuilder.execute());
    }

    private SearchResponse getSearchResponse(ActionFuture<SearchResponse> response) {
        return this.searchTimeout == null ? (SearchResponse)response.actionGet() : (SearchResponse)response.actionGet(this.searchTimeout);
    }

    private <T> boolean createIndexIfNotCreated(Class<T> clazz) {
        return this.indexExists(this.getPersistentEntityFor(clazz).getIndexName()) || this.createIndexWithSettings(clazz);
    }

    private <T> boolean createIndexWithSettings(Class<T> clazz) {
        if (clazz.isAnnotationPresent(Setting.class)) {
            String settingPath = clazz.getAnnotation(Setting.class).settingPath();
            if (!StringUtils.isEmpty((Object)settingPath)) {
                String settings = ElasticsearchTemplate.readFileFromClasspath(settingPath);
                if (!StringUtils.isEmpty((Object)settings)) {
                    return this.createIndex(this.getPersistentEntityFor(clazz).getIndexName(), (Object)settings);
                }
            } else {
                LOGGER.info("settingPath in @Setting has to be defined. Using default instead.");
            }
        }
        return this.createIndex(this.getPersistentEntityFor(clazz).getIndexName(), (Object)this.getDefaultSettings(this.getPersistentEntityFor(clazz)));
    }

    @Override
    public boolean createIndex(String indexName, Object settings) {
        CreateIndexRequestBuilder createIndexRequestBuilder = this.client.admin().indices().prepareCreate(indexName);
        if (settings instanceof String) {
            createIndexRequestBuilder.setSettings(String.valueOf(settings), Requests.INDEX_CONTENT_TYPE);
        } else if (settings instanceof Map) {
            createIndexRequestBuilder.setSettings((Map)settings);
        } else if (settings instanceof XContentBuilder) {
            createIndexRequestBuilder.setSettings((XContentBuilder)settings);
        }
        return ((CreateIndexResponse)createIndexRequestBuilder.execute().actionGet()).isAcknowledged();
    }

    @Override
    public <T> boolean createIndex(Class<T> clazz, Object settings) {
        return this.createIndex(this.getPersistentEntityFor(clazz).getIndexName(), settings);
    }

    private <T> Map getDefaultSettings(ElasticsearchPersistentEntity<T> persistentEntity) {
        if (persistentEntity.isUseServerConfiguration()) {
            return new HashMap();
        }
        return new MapBuilder().put((Object)"index.number_of_shards", (Object)String.valueOf(persistentEntity.getShards())).put((Object)"index.number_of_replicas", (Object)String.valueOf(persistentEntity.getReplicas())).put((Object)"index.refresh_interval", (Object)persistentEntity.getRefreshInterval()).put((Object)"index.store.type", (Object)persistentEntity.getIndexStoreType()).map();
    }

    @Override
    public <T> Map getSetting(Class<T> clazz) {
        return this.getSetting(this.getPersistentEntityFor(clazz).getIndexName());
    }

    @Override
    public Map getSetting(String indexName) {
        Assert.notNull((Object)indexName, (String)"No index defined for getSettings");
        Settings settings = (Settings)((GetSettingsResponse)this.client.admin().indices().getSettings(new GetSettingsRequest()).actionGet()).getIndexToSettings().get((Object)indexName);
        return settings.keySet().stream().collect(Collectors.toMap(key -> key, key -> settings.get(key)));
    }

    private <T> SearchRequestBuilder prepareSearch(Query query, Class<T> clazz) {
        this.setPersistentEntityIndexAndType(query, clazz);
        return this.prepareSearch(query);
    }

    private SearchRequestBuilder prepareSearch(Query query) {
        Assert.notNull(query.getIndices(), (String)"No index defined for Query");
        Assert.notNull(query.getTypes(), (String)"No type defined for Query");
        int startRecord = 0;
        SearchRequestBuilder searchRequestBuilder = this.client.prepareSearch(ElasticsearchTemplate.toArray(query.getIndices())).setSearchType(query.getSearchType()).setTypes(ElasticsearchTemplate.toArray(query.getTypes())).setVersion(true).setTrackScores(query.getTrackScores());
        if (query.getSourceFilter() != null) {
            SourceFilter sourceFilter = query.getSourceFilter();
            searchRequestBuilder.setFetchSource(sourceFilter.getIncludes(), sourceFilter.getExcludes());
        }
        if (query.getPageable().isPaged()) {
            startRecord = query.getPageable().getPageNumber() * query.getPageable().getPageSize();
            searchRequestBuilder.setSize(query.getPageable().getPageSize());
        }
        searchRequestBuilder.setFrom(startRecord);
        if (!query.getFields().isEmpty()) {
            searchRequestBuilder.setFetchSource(ElasticsearchTemplate.toArray(query.getFields()), null);
        }
        if (query.getIndicesOptions() != null) {
            searchRequestBuilder.setIndicesOptions(query.getIndicesOptions());
        }
        if (query.getSort() != null) {
            for (Sort.Order order : query.getSort()) {
                ScoreSortBuilder sort;
                SortOrder sortOrder;
                SortOrder sortOrder2 = sortOrder = order.getDirection().isDescending() ? SortOrder.DESC : SortOrder.ASC;
                if (FIELD_SCORE.equals(order.getProperty())) {
                    sort = (ScoreSortBuilder)SortBuilders.scoreSort().order(sortOrder);
                    searchRequestBuilder.addSort((SortBuilder)sort);
                    continue;
                }
                sort = (FieldSortBuilder)SortBuilders.fieldSort((String)order.getProperty()).order(sortOrder);
                if (order.getNullHandling() == Sort.NullHandling.NULLS_FIRST) {
                    sort.missing((Object)"_first");
                } else if (order.getNullHandling() == Sort.NullHandling.NULLS_LAST) {
                    sort.missing((Object)"_last");
                }
                searchRequestBuilder.addSort((SortBuilder)sort);
            }
        }
        if (query.getMinScore() > 0.0f) {
            searchRequestBuilder.setMinScore(query.getMinScore());
        }
        return searchRequestBuilder;
    }

    private IndexRequestBuilder prepareIndex(IndexQuery query) {
        try {
            String indexName = StringUtils.isEmpty((Object)query.getIndexName()) ? this.retrieveIndexNameFromPersistentEntity(query.getObject().getClass())[0] : query.getIndexName();
            String type = StringUtils.isEmpty((Object)query.getType()) ? this.retrieveTypeFromPersistentEntity(query.getObject().getClass())[0] : query.getType();
            IndexRequestBuilder indexRequestBuilder = null;
            if (query.getObject() != null) {
                String id = StringUtils.isEmpty((Object)query.getId()) ? this.getPersistentEntityId(query.getObject()) : query.getId();
                indexRequestBuilder = id != null ? this.client.prepareIndex(indexName, type, id) : this.client.prepareIndex(indexName, type);
                indexRequestBuilder.setSource(this.resultsMapper.getEntityMapper().mapToString(query.getObject()), Requests.INDEX_CONTENT_TYPE);
            } else if (query.getSource() != null) {
                indexRequestBuilder = this.client.prepareIndex(indexName, type, query.getId()).setSource(query.getSource(), Requests.INDEX_CONTENT_TYPE);
            } else {
                throw new ElasticsearchException("object or source is null, failed to index the document [id: " + query.getId() + "]");
            }
            if (query.getVersion() != null) {
                indexRequestBuilder.setVersion(query.getVersion().longValue());
                VersionType versionType = this.retrieveVersionTypeFromPersistentEntity(query.getObject().getClass());
                indexRequestBuilder.setVersionType(versionType);
            }
            if (query.getParentId() != null) {
                indexRequestBuilder.setParent(query.getParentId());
            }
            return indexRequestBuilder;
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to index the document [id: " + query.getId() + "]", e);
        }
    }

    @Override
    public void refresh(String indexName) {
        Assert.notNull((Object)indexName, (String)"No index defined for refresh()");
        this.client.admin().indices().refresh(Requests.refreshRequest((String[])new String[]{indexName})).actionGet();
    }

    @Override
    public <T> void refresh(Class<T> clazz) {
        this.refresh(this.getPersistentEntityFor(clazz).getIndexName());
    }

    @Override
    public Boolean addAlias(AliasQuery query) {
        Assert.notNull((Object)query.getIndexName(), (String)"No index defined for Alias");
        Assert.notNull((Object)query.getAliasName(), (String)"No alias defined");
        IndicesAliasesRequest.AliasActions aliasAction = IndicesAliasesRequest.AliasActions.add().alias(query.getAliasName()).index(query.getIndexName());
        if (query.getFilterBuilder() != null) {
            aliasAction.filter(query.getFilterBuilder());
        } else if (query.getFilter() != null) {
            aliasAction.filter(query.getFilter());
        } else if (!StringUtils.isEmpty((Object)query.getRouting())) {
            aliasAction.routing(query.getRouting());
        } else if (!StringUtils.isEmpty((Object)query.getSearchRouting())) {
            aliasAction.searchRouting(query.getSearchRouting());
        } else if (!StringUtils.isEmpty((Object)query.getIndexRouting())) {
            aliasAction.indexRouting(query.getIndexRouting());
        }
        return ((AcknowledgedResponse)this.client.admin().indices().prepareAliases().addAliasAction(aliasAction).execute().actionGet()).isAcknowledged();
    }

    @Override
    public Boolean removeAlias(AliasQuery query) {
        Assert.notNull((Object)query.getIndexName(), (String)"No index defined for Alias");
        Assert.notNull((Object)query.getAliasName(), (String)"No alias defined");
        return ((AcknowledgedResponse)this.client.admin().indices().prepareAliases().removeAlias(query.getIndexName(), query.getAliasName()).execute().actionGet()).isAcknowledged();
    }

    @Override
    public List<AliasMetaData> queryForAlias(String indexName) {
        return (List)((GetAliasesResponse)this.client.admin().indices().getAliases(new GetAliasesRequest().indices(new String[]{indexName})).actionGet()).getAliases().get((Object)indexName);
    }

    @Override
    public ElasticsearchPersistentEntity getPersistentEntityFor(Class clazz) {
        Assert.isTrue((boolean)clazz.isAnnotationPresent(Document.class), (String)("Unable to identify index name. " + clazz.getSimpleName() + " is not a Document. Make sure the document class is annotated with @Document(indexName=\"foo\")"));
        return (ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getRequiredPersistentEntity(clazz);
    }

    private String getPersistentEntityId(Object entity) {
        ElasticsearchPersistentEntity persistentEntity = this.getPersistentEntityFor(entity.getClass());
        Object identifier = persistentEntity.getIdentifierAccessor(entity).getIdentifier();
        if (identifier != null) {
            return identifier.toString();
        }
        return null;
    }

    private void setPersistentEntityId(Object entity, String id) {
        ElasticsearchPersistentEntity persistentEntity = this.getPersistentEntityFor(entity.getClass());
        ElasticsearchPersistentProperty idProperty = (ElasticsearchPersistentProperty)persistentEntity.getIdProperty();
        if (idProperty != null && idProperty.getType().isAssignableFrom(String.class)) {
            persistentEntity.getPropertyAccessor(entity).setProperty((PersistentProperty)idProperty, (Object)id);
        }
    }

    private void setPersistentEntityIndexAndType(Query query, Class clazz) {
        if (query.getIndices().isEmpty()) {
            query.addIndices(this.retrieveIndexNameFromPersistentEntity(clazz));
        }
        if (query.getTypes().isEmpty()) {
            query.addTypes(this.retrieveTypeFromPersistentEntity(clazz));
        }
    }

    private String[] retrieveIndexNameFromPersistentEntity(Class clazz) {
        if (clazz != null) {
            return new String[]{this.getPersistentEntityFor(clazz).getIndexName()};
        }
        return null;
    }

    private String[] retrieveTypeFromPersistentEntity(Class clazz) {
        if (clazz != null) {
            return new String[]{this.getPersistentEntityFor(clazz).getIndexType()};
        }
        return null;
    }

    private VersionType retrieveVersionTypeFromPersistentEntity(Class clazz) {
        if (clazz != null) {
            return this.getPersistentEntityFor(clazz).getVersionType();
        }
        return VersionType.EXTERNAL;
    }

    private List<String> extractIds(SearchResponse response) {
        ArrayList<String> ids = new ArrayList<String>();
        for (SearchHit hit : response.getHits()) {
            if (hit == null) continue;
            ids.add(hit.getId());
        }
        return ids;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        if (this.elasticsearchConverter instanceof ApplicationContextAware) {
            ((ApplicationContextAware)this.elasticsearchConverter).setApplicationContext(context);
        }
    }

    private static String[] toArray(List<String> values) {
        String[] valuesAsArray = new String[values.size()];
        return values.toArray(valuesAsArray);
    }

    private static MoreLikeThisQueryBuilder.Item[] toArray(MoreLikeThisQueryBuilder.Item ... values) {
        return values;
    }

    protected ResultsMapper getResultsMapper() {
        return this.resultsMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String readFileFromClasspath(String url) {
        String line;
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        ClassPathResource classPathResource = new ClassPathResource(url);
        InputStreamReader inputStreamReader = new InputStreamReader(classPathResource.getInputStream());
        bufferedReader = new BufferedReader(inputStreamReader);
        String lineSeparator = System.getProperty("line.separator");
        while ((line = bufferedReader.readLine()) != null) {
            stringBuilder.append(line).append(lineSeparator);
        }
        if (bufferedReader == null) return stringBuilder.toString();
        try {
            bufferedReader.close();
            return stringBuilder.toString();
        }
        catch (IOException e) {
            LOGGER.debug(String.format("Unable to close buffered reader.. %s", e.getMessage()));
        }
        return stringBuilder.toString();
        catch (Exception e) {
            String string;
            try {
                LOGGER.debug(String.format("Failed to load file from url: %s: %s", url, e.getMessage()));
                string = null;
                if (bufferedReader == null) return string;
            }
            catch (Throwable throwable) {
                if (bufferedReader == null) throw throwable;
                try {
                    bufferedReader.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    LOGGER.debug(String.format("Unable to close buffered reader.. %s", e2.getMessage()));
                }
                throw throwable;
            }
            try {
                bufferedReader.close();
                return string;
            }
            catch (IOException e3) {
                LOGGER.debug(String.format("Unable to close buffered reader.. %s", e3.getMessage()));
            }
            return string;
        }
    }

    public SearchResponse suggest(SuggestBuilder suggestion, String ... indices) {
        return (SearchResponse)this.client.prepareSearch(indices).suggest(suggestion).get();
    }

    public SearchResponse suggest(SuggestBuilder suggestion, Class clazz) {
        return this.suggest(suggestion, this.retrieveIndexNameFromPersistentEntity(clazz));
    }
}

