/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.reactive;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.data.elasticsearch.client.ElasticsearchHost;
import org.springframework.data.elasticsearch.client.NoReachableHostException;
import org.springframework.data.elasticsearch.client.reactive.HostProvider;
import org.springframework.data.elasticsearch.client.reactive.WebClientProvider;
import org.springframework.lang.Nullable;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

class MultiNodeHostProvider
implements HostProvider {
    private final WebClientProvider clientProvider;
    private final Map<InetSocketAddress, ElasticsearchHost> hosts;

    MultiNodeHostProvider(WebClientProvider clientProvider, InetSocketAddress ... endpoints) {
        this.clientProvider = clientProvider;
        this.hosts = new ConcurrentHashMap<InetSocketAddress, ElasticsearchHost>();
        for (InetSocketAddress endpoint : endpoints) {
            this.hosts.put(endpoint, new ElasticsearchHost(endpoint, ElasticsearchHost.State.UNKNOWN));
        }
    }

    @Override
    public Mono<HostProvider.ClusterInformation> clusterInfo() {
        return this.nodes(null).map(this::updateNodeState).buffer(this.hosts.size()).then(Mono.just((Object)new HostProvider.ClusterInformation(new LinkedHashSet<ElasticsearchHost>(this.hosts.values()))));
    }

    @Override
    public WebClient createWebClient(InetSocketAddress endpoint) {
        return this.clientProvider.get(endpoint);
    }

    @Override
    public Mono<InetSocketAddress> lookupActiveHost(HostProvider.Verification verification) {
        if (HostProvider.Verification.LAZY.equals((Object)verification)) {
            for (ElasticsearchHost entry : this.hosts()) {
                if (!entry.isOnline()) continue;
                return Mono.just((Object)entry.getEndpoint());
            }
        }
        return this.findActiveHostInKnownActives().switchIfEmpty(this.findActiveHostInUnresolved()).switchIfEmpty(this.findActiveHostInDead()).switchIfEmpty(Mono.error(() -> new NoReachableHostException(new LinkedHashSet<ElasticsearchHost>(this.getCachedHostState()))));
    }

    Collection<ElasticsearchHost> getCachedHostState() {
        return this.hosts.values();
    }

    private Mono<InetSocketAddress> findActiveHostInKnownActives() {
        return this.findActiveForSate(ElasticsearchHost.State.ONLINE);
    }

    private Mono<InetSocketAddress> findActiveHostInUnresolved() {
        return this.findActiveForSate(ElasticsearchHost.State.UNKNOWN);
    }

    private Mono<InetSocketAddress> findActiveHostInDead() {
        return this.findActiveForSate(ElasticsearchHost.State.OFFLINE);
    }

    private Mono<InetSocketAddress> findActiveForSate(ElasticsearchHost.State state) {
        return this.nodes(state).map(this::updateNodeState).filter(ElasticsearchHost::isOnline).map(ElasticsearchHost::getEndpoint).next();
    }

    private ElasticsearchHost updateNodeState(Tuple2<InetSocketAddress, ClientResponse> tuple2) {
        ElasticsearchHost.State state = ((ClientResponse)tuple2.getT2()).statusCode().isError() ? ElasticsearchHost.State.OFFLINE : ElasticsearchHost.State.ONLINE;
        ElasticsearchHost elasticsearchHost = new ElasticsearchHost((InetSocketAddress)tuple2.getT1(), state);
        this.hosts.put((InetSocketAddress)tuple2.getT1(), elasticsearchHost);
        return elasticsearchHost;
    }

    private Flux<Tuple2<InetSocketAddress, ClientResponse>> nodes(@Nullable ElasticsearchHost.State state) {
        return Flux.fromIterable(this.hosts()).filter(entry -> state == null || entry.getState().equals((Object)state)).map(ElasticsearchHost::getEndpoint).flatMap(host -> {
            Mono exchange = this.createWebClient((InetSocketAddress)host).head().uri("/", new Object[0]).exchange().doOnError(throwable -> {
                this.hosts.put((InetSocketAddress)host, new ElasticsearchHost((InetSocketAddress)host, ElasticsearchHost.State.OFFLINE));
                this.clientProvider.getErrorListener().accept((Throwable)throwable);
            });
            return Mono.just((Object)host).zipWith(exchange);
        }).onErrorContinue((throwable, o) -> this.clientProvider.getErrorListener().accept((Throwable)throwable));
    }

    private List<ElasticsearchHost> hosts() {
        ArrayList<ElasticsearchHost> hosts = new ArrayList<ElasticsearchHost>(this.hosts.values());
        Collections.shuffle(hosts);
        return hosts;
    }
}

