/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.elc;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.transport.rest_client.RestClientOptions;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.springframework.context.annotation.Bean;
import org.springframework.data.elasticsearch.client.ClientConfiguration;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchClients;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.config.ElasticsearchConfigurationSupport;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.util.Assert;

public abstract class ElasticsearchConfiguration
extends ElasticsearchConfigurationSupport {
    @Bean(name={"elasticsearchClientConfiguration"})
    public abstract ClientConfiguration clientConfiguration();

    @Bean
    public RestClient elasticsearchRestClient(ClientConfiguration clientConfiguration) {
        Assert.notNull((Object)clientConfiguration, (String)"clientConfiguration must not be null");
        return ElasticsearchClients.getRestClient(clientConfiguration);
    }

    @Bean
    public ElasticsearchTransport elasticsearchTransport(RestClient restClient, JsonpMapper jsonpMapper) {
        Assert.notNull((Object)restClient, (String)"restClient must not be null");
        Assert.notNull((Object)jsonpMapper, (String)"jsonpMapper must not be null");
        return ElasticsearchClients.getElasticsearchTransport(restClient, "imperative", this.transportOptions(), jsonpMapper);
    }

    @Bean
    public ElasticsearchClient elasticsearchClient(ElasticsearchTransport transport) {
        Assert.notNull((Object)transport, (String)"transport must not be null");
        return ElasticsearchClients.createImperative(transport);
    }

    @Bean(name={"elasticsearchOperations", "elasticsearchTemplate"})
    public ElasticsearchOperations elasticsearchOperations(ElasticsearchConverter elasticsearchConverter, ElasticsearchClient elasticsearchClient) {
        ElasticsearchTemplate template = new ElasticsearchTemplate(elasticsearchClient, elasticsearchConverter);
        template.setRefreshPolicy(this.refreshPolicy());
        return template;
    }

    @Bean
    public JsonpMapper jsonpMapper() {
        ObjectMapper objectMapper = new ObjectMapper().configure(SerializationFeature.INDENT_OUTPUT, false).setSerializationInclusion(JsonInclude.Include.ALWAYS);
        return new JacksonJsonpMapper(objectMapper);
    }

    public TransportOptions transportOptions() {
        return new RestClientOptions(RequestOptions.DEFAULT);
    }
}

