/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.index;

import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.core.query.Query;

public class AliasData {
    private final String alias;
    private final @Nullable Query filterQuery;
    private final @Nullable String indexRouting;
    private final @Nullable String searchRouting;
    private final @Nullable Boolean isWriteIndex;
    private final @Nullable Boolean isHidden;

    private AliasData(String alias, @Nullable Query filterQuery, @Nullable String indexRouting, @Nullable String searchRouting, @Nullable Boolean isWriteIndex, @Nullable Boolean isHidden) {
        this.alias = alias;
        this.filterQuery = filterQuery;
        this.indexRouting = indexRouting;
        this.searchRouting = searchRouting;
        this.isWriteIndex = isWriteIndex;
        this.isHidden = isHidden;
    }

    public static AliasData of(String alias, @Nullable Query filterQuery, @Nullable String indexRouting, @Nullable String searchRouting, @Nullable Boolean isWriteIndex, @Nullable Boolean isHidden) {
        return new AliasData(alias, filterQuery, indexRouting, searchRouting, isWriteIndex, isHidden);
    }

    public String getAlias() {
        return this.alias;
    }

    public @Nullable Query getFilterQuery() {
        return this.filterQuery;
    }

    public @Nullable String getIndexRouting() {
        return this.indexRouting;
    }

    public @Nullable String getSearchRouting() {
        return this.searchRouting;
    }

    public @Nullable Boolean isWriteIndex() {
        return this.isWriteIndex;
    }

    public @Nullable Boolean isHidden() {
        return Boolean.TRUE.equals(this.isHidden);
    }
}

