/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.query;

import org.jspecify.annotations.Nullable;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public interface ReactiveElasticsearchQueryExecution {
    public Object execute(Query var1, Class<?> var2, @Nullable Class<?> var3, IndexCoordinates var4);

    public static final class ResultProcessingConverter
    implements Converter<Object, Object> {
        private final ResultProcessor processor;

        public ResultProcessingConverter(ResultProcessor processor) {
            Assert.notNull((Object)processor, (String)"processor must not be null");
            this.processor = processor;
        }

        public Object convert(Object source) {
            ReturnedType returnedType = this.processor.getReturnedType();
            if (ClassUtils.isPrimitiveOrWrapper((Class)returnedType.getReturnedType())) {
                return source;
            }
            return this.processor.processResult(source, it -> it);
        }
    }

    public static final class ResultProcessingExecution
    implements ReactiveElasticsearchQueryExecution {
        private final ReactiveElasticsearchQueryExecution delegate;
        private final Converter<Object, Object> converter;

        public ResultProcessingExecution(ReactiveElasticsearchQueryExecution delegate, Converter<Object, Object> converter) {
            Assert.notNull((Object)delegate, (String)"delegate must not be null");
            Assert.notNull(converter, (String)"converter must not be null");
            this.delegate = delegate;
            this.converter = converter;
        }

        @Override
        public Object execute(Query query, Class<?> type, @Nullable Class<?> targetType, IndexCoordinates indexCoordinates) {
            return this.converter.convert(this.delegate.execute(query, type, targetType, indexCoordinates));
        }
    }
}

