/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.RegionFactory;
import org.springframework.data.gemfire.DataPolicyConverter;
import org.springframework.data.gemfire.RegionFactoryBean;
import org.springframework.util.Assert;

public class ReplicatedRegionFactoryBean<K, V>
extends RegionFactoryBean<K, V> {
    @Override
    protected void resolveDataPolicy(RegionFactory<K, V> regionFactory, Boolean persistent, String dataPolicy) {
        DataPolicy dp = null;
        if (dataPolicy != null) {
            if ("EMPTY".equals(dataPolicy = dataPolicy.toUpperCase())) {
                Assert.isTrue((persistent == null || persistent == false ? 1 : 0) != 0, (String)"Cannot have persistence on an empty region");
                dp = DataPolicy.EMPTY;
            } else {
                dp = new DataPolicyConverter().convert(dataPolicy);
                Assert.notNull((Object)dp, (String)("Data policy " + dataPolicy + " is invalid"));
                Assert.isTrue((boolean)dp.withReplication(), (String)("Data policy " + dataPolicy + " is invalid or unsupported in replicated regions"));
                if (this.isPersistent()) {
                    Assert.isTrue((boolean)dp.withPersistence(), (String)("Data policy " + dataPolicy + " is invalid when persistent is false"));
                }
            }
        } else {
            dp = this.isPersistent() ? DataPolicy.PERSISTENT_REPLICATE : DataPolicy.REPLICATE;
        }
        regionFactory.setDataPolicy(dp);
    }
}

