/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config;

import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.config.ParsingUtils;
import org.springframework.data.gemfire.server.CacheServerFactoryBean;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

class CacheServerParser
extends AbstractSimpleBeanDefinitionParser {
    CacheServerParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return CacheServerFactoryBean.class;
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String name = super.resolveId(element, definition, parserContext);
        if (!StringUtils.hasText((String)name)) {
            name = "gemfireServer";
        }
        return name;
    }

    protected boolean isEligibleAttribute(Attr attribute, ParserContext parserContext) {
        return super.isEligibleAttribute(attribute, parserContext) && !"groups".equals(attribute.getName()) && !"cache-ref".equals(attribute.getName());
    }

    protected void postProcess(BeanDefinitionBuilder builder, Element element) {
        String attr = element.getAttribute("cache-ref");
        builder.addPropertyReference("cache", StringUtils.hasText((String)attr) ? attr : "gemfireCache");
        attr = element.getAttribute("groups");
        if (StringUtils.hasText((String)attr)) {
            builder.addPropertyValue("serverGroups", (Object)StringUtils.commaDelimitedListToStringArray((String)attr));
        }
        this.parseSubscription(builder, element);
    }

    private void parseSubscription(BeanDefinitionBuilder builder, Element element) {
        Element subConfig = DomUtils.getChildElementByTagName((Element)element, (String)"subscription-config");
        if (subConfig == null) {
            return;
        }
        ParsingUtils.setPropertyValue(subConfig, builder, "capacity", "subscriptionCapacity");
        ParsingUtils.setPropertyValue(subConfig, builder, "disk-store", "subscriptionDiskStore");
        String attr = element.getAttribute("eviction-type");
        if (StringUtils.hasText((String)attr)) {
            builder.addPropertyValue("subscriptionEvictionPolicy", (Object)attr.toUpperCase());
        }
    }
}

