/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.GemFireCache;
import java.io.File;
import java.util.List;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DiskStoreFactoryBean
implements FactoryBean<DiskStore>,
InitializingBean,
BeanNameAware {
    private Boolean allowForceCompaction;
    private Boolean autoCompact;
    private DiskStore diskStore;
    private GemFireCache cache;
    private Integer compactionThreshold;
    private Integer maxOplogSize;
    private Integer queueSize;
    private Integer timeInterval;
    private Integer writeBufferSize;
    private List<DiskDir> diskDirs;
    private String name;

    public DiskStore getObject() throws Exception {
        return this.diskStore;
    }

    public Class<?> getObjectType() {
        return DiskStore.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.cache != null ? 1 : 0) != 0, (String)String.format("A reference to the GemFire Cache must be set for Disk Store '%1$s'.", this.getName()));
        DiskStoreFactory diskStoreFactory = this.cache.createDiskStoreFactory();
        if (this.allowForceCompaction != null) {
            diskStoreFactory.setAllowForceCompaction(this.allowForceCompaction.booleanValue());
        }
        if (this.compactionThreshold != null) {
            diskStoreFactory.setCompactionThreshold(this.compactionThreshold.intValue());
        }
        if (this.autoCompact != null) {
            diskStoreFactory.setAutoCompact(this.autoCompact.booleanValue());
        }
        if (this.queueSize != null) {
            diskStoreFactory.setQueueSize(this.queueSize.intValue());
        }
        if (this.writeBufferSize != null) {
            diskStoreFactory.setWriteBufferSize(this.writeBufferSize.intValue());
        }
        if (this.timeInterval != null) {
            diskStoreFactory.setTimeInterval((long)this.timeInterval.intValue());
        }
        if (this.maxOplogSize != null) {
            diskStoreFactory.setMaxOplogSize((long)this.maxOplogSize.intValue());
        }
        if (!CollectionUtils.isEmpty(this.diskDirs)) {
            File[] diskDirFiles = new File[this.diskDirs.size()];
            int[] diskDirSizes = new int[this.diskDirs.size()];
            for (int i = 0; i < this.diskDirs.size(); ++i) {
                DiskDir diskDir = this.diskDirs.get(i);
                diskDirFiles[i] = new File(diskDir.location);
                diskDirSizes[i] = diskDir.maxSize == null ? Integer.MAX_VALUE : diskDir.maxSize;
            }
            diskStoreFactory.setDiskDirsAndSizes(diskDirFiles, diskDirSizes);
        }
        this.diskStore = diskStoreFactory.create(this.getName());
        Assert.notNull((Object)this.diskStore, (String)String.format("The DiskStore with name '%1$s' failed to be created successfully.", this.diskStore.getName()));
    }

    public void setCache(GemFireCache cache) {
        this.cache = cache;
    }

    public void setAllowForceCompaction(Boolean allowForceCompaction) {
        this.allowForceCompaction = allowForceCompaction;
    }

    public void setAutoCompact(Boolean autoCompact) {
        this.autoCompact = autoCompact;
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    public void setCompactionThreshold(Integer compactionThreshold) {
        this.validateCompactionThreshold(compactionThreshold);
        this.compactionThreshold = compactionThreshold;
    }

    protected void validateCompactionThreshold(Integer compactionThreshold) {
        Assert.isTrue((compactionThreshold == null || compactionThreshold >= 0 && compactionThreshold <= 100 ? 1 : 0) != 0, (String)String.format("The DiskStore's (%1$s) compaction threshold (%2$d) must be an integer value between 0 and 100 inclusive.", this.name, compactionThreshold));
    }

    public void setDiskDirs(List<DiskDir> diskDirs) {
        this.diskDirs = diskDirs;
    }

    public void setMaxOplogSize(Integer maxOplogSize) {
        this.maxOplogSize = maxOplogSize;
    }

    public void setQueueSize(Integer queueSize) {
        this.queueSize = queueSize;
    }

    public void setTimeInterval(Integer timeInterval) {
        this.timeInterval = timeInterval;
    }

    public void setWriteBufferSize(Integer writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
    }

    final String getName() {
        return StringUtils.hasText((String)this.name) ? this.name : "DEFAULT";
    }

    public static class DiskDir {
        final Integer maxSize;
        final String location;

        public DiskDir(String location, int maxSize) {
            this.location = location;
            this.maxSize = maxSize;
        }

        public DiskDir(String location) {
            this.location = location;
            this.maxSize = null;
        }
    }
}

