/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.cache.RegionService;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.IndexExistsException;
import com.gemstone.gemfire.cache.query.QueryService;
import java.util.Collection;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class IndexFactoryBean
implements InitializingBean,
BeanNameAware,
FactoryBean<Index> {
    private Index index;
    private QueryService queryService;
    private RegionService cache;
    private String beanName;
    private String name;
    private String expression;
    private String from;
    private String imports;
    private String type;
    private boolean override = true;

    public void afterPropertiesSet() throws Exception {
        if (this.queryService == null && this.cache != null) {
            this.queryService = this.cache.getQueryService();
        }
        Assert.notNull((Object)this.queryService, (String)"Query service required for index creation");
        Assert.hasText((String)this.expression, (String)"Index expression is required");
        Assert.hasText((String)this.from, (String)"Index from clause (regionPath) is required");
        if (StringUtils.hasText((String)this.type) && (this.type.equalsIgnoreCase("KEY") || this.type.equalsIgnoreCase("PRIMARY_KEY"))) {
            Assert.isNull((Object)this.imports, (String)"The imports property is not supported for a key index");
        }
        String indexName = StringUtils.hasText((String)this.name) ? this.name : this.beanName;
        Assert.hasText((String)indexName, (String)"Index bean id or name is required");
        this.index = this.createIndex(this.queryService, indexName);
    }

    private Index createIndex(QueryService queryService, String indexName) throws Exception {
        Index index;
        block7: {
            Index existingIndex = null;
            for (Index idx : queryService.getIndexes()) {
                if (!idx.getName().equals(indexName)) continue;
                existingIndex = idx;
                break;
            }
            if (existingIndex != null) {
                if (!this.override) {
                    return existingIndex;
                }
                queryService.removeIndex(existingIndex);
            }
            index = null;
            try {
                index = "KEY".equalsIgnoreCase(this.type) || "PRIMARY_KEY".equalsIgnoreCase(this.type) ? queryService.createKeyIndex(indexName, this.expression, this.from) : ("HASH".equalsIgnoreCase(this.type) ? (StringUtils.hasText((String)this.imports) ? queryService.createHashIndex(indexName, this.expression, this.from, this.imports) : queryService.createHashIndex(indexName, this.expression, this.from)) : (StringUtils.hasText((String)this.imports) ? queryService.createIndex(indexName, this.expression, this.from, this.imports) : queryService.createIndex(indexName, this.expression, this.from)));
                return index;
            }
            catch (IndexExistsException e) {
                for (Index idx : queryService.getIndexes()) {
                    if (!idx.getName().equals(indexName)) continue;
                    return idx;
                }
            }
            catch (Exception e) {
                if (existingIndex == null || !CollectionUtils.isEmpty((Collection)queryService.getIndexes()) && queryService.getIndexes().contains(existingIndex)) break block7;
                queryService.getIndexes().add(existingIndex);
            }
        }
        return index;
    }

    public Index getObject() {
        return this.index;
    }

    public Class<?> getObjectType() {
        return this.index != null ? this.index.getClass() : Index.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setCache(RegionService cache) {
        this.cache = cache;
    }

    public void setQueryService(QueryService service) {
        this.queryService = service;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setImports(String imports) {
        this.imports = imports;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setOverride(boolean override) {
        this.override = override;
    }
}

