/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.client;

import com.gemstone.gemfire.cache.InterestResultPolicy;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.Constants;
import org.springframework.util.Assert;

public class Interest<K>
implements InitializingBean {
    private static final Constants constants = new Constants(InterestResultPolicy.class);
    private K key;
    private InterestResultPolicy policy = InterestResultPolicy.DEFAULT;
    private boolean durable = false;
    private boolean receiveValues = true;

    public Interest() {
    }

    public Interest(K key) {
        this(key, InterestResultPolicy.DEFAULT, false);
    }

    public Interest(K key, InterestResultPolicy policy) {
        this(key, policy, false);
    }

    public Interest(K key, String policy) {
        this(key, policy, false);
    }

    public Interest(K key, String policy, boolean durable) {
        this(key, policy, false, true);
    }

    public Interest(K key, String policy, boolean durable, boolean receiveValues) {
        this(key, (InterestResultPolicy)constants.asObject(policy), durable, receiveValues);
    }

    public Interest(K key, InterestResultPolicy policy, boolean durable) {
        this(key, policy, durable, true);
    }

    public Interest(K key, InterestResultPolicy policy, boolean durable, boolean receiveValues) {
        this.key = key;
        this.policy = policy;
        this.durable = durable;
        this.receiveValues = receiveValues;
        this.afterPropertiesSet();
    }

    public void afterPropertiesSet() {
        Assert.notNull(this.key, (String)"a non-null key is required");
    }

    protected K getKey() {
        return this.key;
    }

    public void setKey(K key) {
        this.key = key;
    }

    protected InterestResultPolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(Object policy) {
        if (policy instanceof InterestResultPolicy) {
            this.policy = (InterestResultPolicy)policy;
        } else if (policy instanceof String) {
            this.policy = (InterestResultPolicy)constants.asObject((String)policy);
        } else {
            throw new IllegalArgumentException("Unknown argument type for property 'policy'" + policy);
        }
    }

    protected boolean isDurable() {
        return this.durable;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    protected boolean isReceiveValues() {
        return this.receiveValues;
    }

    public void setReceiveValues(boolean receiveValues) {
        this.receiveValues = receiveValues;
    }
}

