/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.mapping;

import com.gemstone.gemfire.pdx.PdxReader;
import com.gemstone.gemfire.pdx.PdxSerializer;
import com.gemstone.gemfire.pdx.PdxWriter;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.gemfire.mapping.GemfireMappingContext;
import org.springframework.data.gemfire.mapping.GemfirePersistentEntity;
import org.springframework.data.gemfire.mapping.GemfirePersistentProperty;
import org.springframework.data.gemfire.mapping.GemfirePropertyValueProvider;
import org.springframework.data.gemfire.mapping.PdxReaderPropertyAccessor;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.mapping.model.SpELContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.util.Assert;

public class MappingPdxSerializer
implements PdxSerializer,
ApplicationContextAware {
    private final GemfireMappingContext mappingContext;
    private final ConversionService conversionService;
    private EntityInstantiators instantiators;
    private Map<Class<?>, PdxSerializer> customSerializers;
    private SpELContext context;

    public MappingPdxSerializer(GemfireMappingContext mappingContext, ConversionService conversionService) {
        Assert.notNull((Object)((Object)mappingContext));
        Assert.notNull((Object)conversionService);
        this.mappingContext = mappingContext;
        this.conversionService = conversionService;
        this.instantiators = new EntityInstantiators();
        this.context = new SpELContext((PropertyAccessor)PdxReaderPropertyAccessor.INSTANCE);
    }

    public MappingPdxSerializer() {
        this(new GemfireMappingContext(), (ConversionService)new DefaultConversionService());
    }

    public void setGemfireInstantiators(Map<Class<?>, EntityInstantiator> gemfireInstantiators) {
        Assert.notNull(gemfireInstantiators);
        this.instantiators = new EntityInstantiators(gemfireInstantiators);
    }

    public void setCustomSerializers(Map<Class<?>, PdxSerializer> customSerializers) {
        this.customSerializers = customSerializers;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = new SpELContext(this.context, (BeanFactory)applicationContext);
    }

    public Object fromData(Class<?> type, final PdxReader reader) {
        final GemfirePersistentEntity entity = (GemfirePersistentEntity)this.mappingContext.getPersistentEntity(type);
        EntityInstantiator instantiator = this.instantiators.getInstantiatorFor((PersistentEntity)entity);
        GemfirePropertyValueProvider propertyValueProvider = new GemfirePropertyValueProvider(reader);
        PersistentEntityParameterValueProvider provider = new PersistentEntityParameterValueProvider((PersistentEntity)entity, (PropertyValueProvider)propertyValueProvider, null);
        Object instance = instantiator.createInstance((PersistentEntity)entity, (ParameterValueProvider)provider);
        final BeanWrapper wrapper = BeanWrapper.create((Object)instance, (ConversionService)this.conversionService);
        entity.doWithProperties((PropertyHandler)new PropertyHandler<GemfirePersistentProperty>(){

            public void doWithPersistentProperty(GemfirePersistentProperty persistentProperty) {
                if (entity.isConstructorArgument((PersistentProperty)persistentProperty)) {
                    return;
                }
                PdxSerializer customSerializer = MappingPdxSerializer.this.getCustomSerializer(persistentProperty.getType());
                Object value = null;
                value = customSerializer != null ? customSerializer.fromData(persistentProperty.getType(), reader) : reader.readField(persistentProperty.getName());
                try {
                    wrapper.setProperty((PersistentProperty)persistentProperty, value);
                }
                catch (Exception e) {
                    throw new MappingException("Could not read value " + value.toString(), (Throwable)e);
                }
            }
        });
        return wrapper.getBean();
    }

    public boolean toData(Object value, final PdxWriter writer) {
        GemfirePersistentEntity entity = (GemfirePersistentEntity)this.mappingContext.getPersistentEntity(value.getClass());
        final BeanWrapper wrapper = BeanWrapper.create((Object)value, (ConversionService)this.conversionService);
        entity.doWithProperties((PropertyHandler)new PropertyHandler<GemfirePersistentProperty>(){

            public void doWithPersistentProperty(GemfirePersistentProperty persistentProperty) {
                try {
                    Object propertyValue = wrapper.getProperty((PersistentProperty)persistentProperty);
                    PdxSerializer customSerializer = MappingPdxSerializer.this.getCustomSerializer(persistentProperty.getType());
                    if (customSerializer != null) {
                        customSerializer.toData(propertyValue, writer);
                    } else {
                        writer.writeField(persistentProperty.getName(), propertyValue, persistentProperty.getType());
                    }
                }
                catch (Exception e) {
                    throw new MappingException("Could not write value for property " + persistentProperty.toString(), (Throwable)e);
                }
            }
        });
        GemfirePersistentProperty idProperty = (GemfirePersistentProperty)entity.getIdProperty();
        if (idProperty != null) {
            writer.markIdentityField(idProperty.getName());
        }
        return true;
    }

    private PdxSerializer getCustomSerializer(Class<?> clazz) {
        return this.customSerializers == null ? null : this.customSerializers.get(clazz);
    }
}

