/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.query;

import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.internal.ResultsBag;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.gemfire.GemfireTemplate;
import org.springframework.data.gemfire.repository.query.GemfireQueryMethod;
import org.springframework.data.gemfire.repository.query.GemfireRepositoryQuery;
import org.springframework.data.gemfire.repository.query.QueryString;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class StringBasedGemfireRepositoryQuery
extends GemfireRepositoryQuery {
    private static final String INVALID_QUERY = "Paging and modifying queries are not supported!";
    private boolean userDefinedQuery = false;
    private final GemfireQueryMethod method;
    private final GemfireTemplate template;
    private final QueryString query;

    StringBasedGemfireRepositoryQuery() {
        this.query = null;
        this.method = null;
        this.template = null;
    }

    public StringBasedGemfireRepositoryQuery(GemfireQueryMethod method, GemfireTemplate template) {
        this(method.getAnnotatedQuery(), method, template);
    }

    public StringBasedGemfireRepositoryQuery(String query, GemfireQueryMethod method, GemfireTemplate template) {
        super(method);
        Assert.notNull((Object)template);
        this.userDefinedQuery |= !StringUtils.hasText((String)query);
        this.query = new QueryString(StringUtils.hasText((String)query) ? query : method.getAnnotatedQuery());
        this.method = method;
        this.template = template;
        if (method.isPageQuery() || method.isModifyingQuery()) {
            throw new IllegalStateException(INVALID_QUERY);
        }
    }

    public StringBasedGemfireRepositoryQuery asUserDefinedQuery() {
        this.userDefinedQuery = true;
        return this;
    }

    public boolean isUserDefinedQuery() {
        return this.userDefinedQuery;
    }

    public Object execute(Object[] parameters) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.method.getParameters(), parameters);
        QueryString query = this.isUserDefinedQuery() ? this.query : this.query.forRegion(this.method.getEntityInformation().getJavaType(), this.template.getRegion());
        for (Integer index : query.getInParameterIndexes()) {
            query = query.bindIn(this.toCollection(accessor.getBindableValue(index - 1)));
        }
        Collection<?> result = this.toCollection(this.template.find(query.toString(), parameters));
        if (this.method.isCollectionQuery()) {
            return result;
        }
        if (this.method.isQueryForEntity()) {
            if (result.isEmpty()) {
                return null;
            }
            if (result.size() == 1) {
                return result.iterator().next();
            }
            throw new IncorrectResultSizeDataAccessException(1, result.size());
        }
        throw new IllegalStateException("Unsupported query: " + query.toString());
    }

    Collection<?> toCollection(Object source) {
        if (source instanceof SelectResults) {
            return ((SelectResults)source).asList();
        }
        if (source instanceof ResultsBag) {
            return ((ResultsBag)source).asList();
        }
        if (source instanceof Collection) {
            return (Collection)source;
        }
        if (source == null) {
            return Collections.emptyList();
        }
        return source.getClass().isArray() ? CollectionUtils.arrayToList((Object)source) : Arrays.asList(source);
    }
}

