/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config;

import java.net.InetSocketAddress;
import java.util.List;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.client.PoolFactoryBean;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class PoolParser
extends AbstractSimpleBeanDefinitionParser {
    protected static final int DEFAULT_LOCATOR_PORT = 10334;
    protected static final int DEFAULT_SERVER_PORT = 40404;
    protected static final String DEFAULT_HOST = "localhost";
    protected static final String HOST_ATTRIBUTE_NAME = "host";
    protected static final String LOCATOR_ELEMENT_NAME = "locator";
    protected static final String LOCATORS_ATTRIBUTE_NAME = "locators";
    protected static final String PORT_ATTRIBUTE_NAME = "port";
    protected static final String SERVER_ELEMENT_NAME = "server";
    protected static final String SERVERS_ATTRIBUTE_NAME = "servers";

    PoolParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return PoolFactoryBean.class;
    }

    protected void postProcess(BeanDefinitionBuilder builder, Element element) {
        List subElements = DomUtils.getChildElements((Element)element);
        ManagedList locators = new ManagedList(subElements.size());
        ManagedList servers = new ManagedList(subElements.size());
        for (Element subElement : subElements) {
            String name = subElement.getLocalName();
            if (LOCATOR_ELEMENT_NAME.equals(name)) {
                locators.add((Object)this.parseLocator(subElement));
            }
            if (!SERVER_ELEMENT_NAME.equals(name)) continue;
            servers.add((Object)this.parseServer(subElement));
        }
        locators.addAll(this.parseLocators(element));
        servers.addAll(this.parseServers(element));
        if (locators.isEmpty() && servers.isEmpty()) {
            locators.add((Object)this.buildConnection(DEFAULT_HOST, String.valueOf(10334), false));
        }
        if (!locators.isEmpty()) {
            builder.addPropertyValue(LOCATORS_ATTRIBUTE_NAME, (Object)locators);
        }
        if (!servers.isEmpty()) {
            builder.addPropertyValue(SERVERS_ATTRIBUTE_NAME, (Object)servers);
        }
    }

    BeanDefinition buildConnection(String host, String port, boolean server) {
        BeanDefinitionBuilder inetSocketAddressBuilder = BeanDefinitionBuilder.genericBeanDefinition(InetSocketAddress.class);
        inetSocketAddressBuilder.addConstructorArgValue((Object)this.defaultHost(host));
        inetSocketAddressBuilder.addConstructorArgValue((Object)this.defaultPort(port, server));
        return inetSocketAddressBuilder.getBeanDefinition();
    }

    String defaultHost(String host) {
        return StringUtils.hasText((String)host) ? host : DEFAULT_HOST;
    }

    String defaultPort(String port, boolean server) {
        return StringUtils.hasText((String)port) ? port : (server ? String.valueOf(40404) : String.valueOf(10334));
    }

    ManagedList<BeanDefinition> parseConnections(String hostPortCommaDelimitedList, boolean server) {
        ManagedList connections = new ManagedList();
        if (StringUtils.hasText((String)hostPortCommaDelimitedList)) {
            String[] hostPorts;
            for (String hostPort : hostPorts = hostPortCommaDelimitedList.split(",")) {
                connections.add((Object)this.parseConnection(hostPort, server));
            }
        }
        return connections;
    }

    BeanDefinition parseConnection(String hostPort, boolean server) {
        String host;
        String port = this.defaultPort(null, server);
        int portIndex = hostPort.indexOf(91);
        if (portIndex > -1) {
            host = hostPort.substring(0, portIndex).trim();
            port = this.parseDigits(hostPort.substring(portIndex)).trim();
        } else {
            host = hostPort.trim();
        }
        return this.buildConnection(host, port, server);
    }

    String parseDigits(String value) {
        StringBuilder digits = new StringBuilder();
        for (char chr : value.toCharArray()) {
            if (!Character.isDigit(chr)) continue;
            digits.append(chr);
        }
        return digits.toString();
    }

    BeanDefinition parseLocator(Element element) {
        return this.buildConnection(element.getAttribute(HOST_ATTRIBUTE_NAME), element.getAttribute(PORT_ATTRIBUTE_NAME), false);
    }

    ManagedList<BeanDefinition> parseLocators(Element element) {
        return this.parseConnections(element.getAttribute(LOCATORS_ATTRIBUTE_NAME), false);
    }

    BeanDefinition parseServer(Element element) {
        return this.buildConnection(element.getAttribute(HOST_ATTRIBUTE_NAME), element.getAttribute(PORT_ATTRIBUTE_NAME), false);
    }

    ManagedList<BeanDefinition> parseServers(Element element) {
        return this.parseConnections(element.getAttribute(SERVERS_ATTRIBUTE_NAME), true);
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = super.resolveId(element, definition, parserContext);
        if (!StringUtils.hasText((String)id)) {
            id = "DEFAULT";
            parserContext.getRegistry().registerAlias("DEFAULT", "gemfirePool");
            parserContext.getRegistry().registerAlias("DEFAULT", "gemfire-pool");
        }
        return id;
    }
}

