/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function;

import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.ResultSender;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.gemfire.function.BatchingResultSender;
import org.springframework.data.gemfire.function.FunctionArgumentResolver;
import org.springframework.data.gemfire.function.FunctionContextInjectingArgumentResolver;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class PojoFunctionWrapper
implements Function {
    private static transient Log logger = LogFactory.getLog(PojoFunctionWrapper.class);
    private volatile boolean HA;
    private volatile boolean hasResult;
    private volatile boolean optimizeForWrite;
    private volatile int batchSize;
    private final FunctionArgumentResolver functionArgumentResolver;
    private final Method method;
    private final Object target;
    private final String id;

    public PojoFunctionWrapper(Object target, Method method, String id) {
        this.functionArgumentResolver = new FunctionContextInjectingArgumentResolver(method);
        this.target = target;
        this.method = method;
        this.id = StringUtils.hasText((String)id) ? id : method.getName();
        this.HA = false;
        this.hasResult = !method.getReturnType().equals(Void.TYPE);
        this.optimizeForWrite = false;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setHA(boolean HA) {
        this.HA = HA;
    }

    public boolean isHA() {
        return this.HA;
    }

    public void setHasResult(boolean hasResult) {
        this.hasResult = hasResult;
    }

    public boolean hasResult() {
        return this.hasResult;
    }

    public String getId() {
        return this.id;
    }

    public void setOptimizeForWrite(boolean optimizeForWrite) {
        this.optimizeForWrite = optimizeForWrite;
    }

    public boolean optimizeForWrite() {
        return this.optimizeForWrite;
    }

    public void execute(FunctionContext functionContext) {
        Object[] args = this.functionArgumentResolver.resolveFunctionArguments(functionContext);
        Object result = this.invokeTargetMethod(args);
        if (this.hasResult()) {
            this.sendResults((ResultSender<Object>)functionContext.getResultSender(), result);
        }
    }

    protected final Object invokeTargetMethod(Object[] args) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("about to invoke method %s on class %s as function %s", this.method.getName(), this.target.getClass().getName(), this.id));
            for (Object arg : args) {
                logger.debug((Object)("arg:" + arg.getClass().getName() + " " + arg.toString()));
            }
        }
        return ReflectionUtils.invokeMethod((Method)this.method, (Object)this.target, (Object[])args);
    }

    private void sendResults(ResultSender<Object> resultSender, Object result) {
        if (result == null) {
            resultSender.lastResult(null);
        } else if (ObjectUtils.isArray((Object)result)) {
            new BatchingResultSender(this.batchSize, resultSender).sendArrayResults(result);
        } else if (Iterable.class.isAssignableFrom(result.getClass())) {
            new BatchingResultSender(this.batchSize, resultSender).sendResults((Iterable)result);
        } else {
            resultSender.lastResult(result);
        }
    }
}

