/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.data.gemfire.mapping.GemfireMappingContext;
import org.springframework.data.gemfire.repository.support.GemfireRepositoryFactoryBean;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.util.StringUtils;

public class GemfireRepositoryConfigurationExtension
extends RepositoryConfigurationExtensionSupport {
    private static final String ANNOTATION_MAPPING_CONTEXT_REF = "mappingContextRef";
    private static final String MAPPING_CONTEXT_PROPERTY_NAME = "gemfireMappingContext";
    private static final String XML_MAPPING_CONTEXT_REF = "mapping-context-ref";
    static final String DEFAULT_MAPPING_CONTEXT_BEAN_NAME = String.format("%1$s.%2$s", GemfireMappingContext.class.getName(), "DEFAULT");

    public String getRepositoryFactoryClassName() {
        return GemfireRepositoryFactoryBean.class.getName();
    }

    protected String getModulePrefix() {
        return "gemfire";
    }

    public void registerBeansForRoot(BeanDefinitionRegistry registry, RepositoryConfigurationSource configurationSource) {
        super.registerBeansForRoot(registry, configurationSource);
        String attribute = configurationSource.getAttribute(ANNOTATION_MAPPING_CONTEXT_REF);
        if (!StringUtils.hasText((String)attribute)) {
            registry.registerBeanDefinition(DEFAULT_MAPPING_CONTEXT_BEAN_NAME, (BeanDefinition)new RootBeanDefinition(GemfireMappingContext.class));
        }
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        String mappingContextRef = config.getAttribute(ANNOTATION_MAPPING_CONTEXT_REF);
        builder.addPropertyReference(MAPPING_CONTEXT_PROPERTY_NAME, GemfireRepositoryConfigurationExtension.getDefaultedMappingContextBeanName(mappingContextRef));
    }

    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
        String mappingContextRef = config.getElement().getAttribute(XML_MAPPING_CONTEXT_REF);
        builder.addPropertyReference(MAPPING_CONTEXT_PROPERTY_NAME, GemfireRepositoryConfigurationExtension.getDefaultedMappingContextBeanName(mappingContextRef));
    }

    private static String getDefaultedMappingContextBeanName(String source) {
        return StringUtils.hasText((String)source) ? source : DEFAULT_MAPPING_CONTEXT_BEAN_NAME;
    }
}

