/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.support;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.data.gemfire.GemfireTemplate;
import org.springframework.data.gemfire.mapping.GemfirePersistentEntity;
import org.springframework.data.gemfire.mapping.GemfirePersistentProperty;
import org.springframework.data.gemfire.mapping.Region;
import org.springframework.data.gemfire.mapping.Regions;
import org.springframework.data.gemfire.repository.query.DefaultGemfireEntityInformation;
import org.springframework.data.gemfire.repository.query.GemfireEntityInformation;
import org.springframework.data.gemfire.repository.query.GemfireQueryMethod;
import org.springframework.data.gemfire.repository.query.PartTreeGemfireRepositoryQuery;
import org.springframework.data.gemfire.repository.query.StringBasedGemfireRepositoryQuery;
import org.springframework.data.gemfire.repository.support.SimpleGemfireRepository;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class GemfireRepositoryFactory
extends RepositoryFactorySupport {
    private final MappingContext<? extends GemfirePersistentEntity<?>, GemfirePersistentProperty> context;
    private final Regions regions;

    public GemfireRepositoryFactory(Iterable<com.gemstone.gemfire.cache.Region<?, ?>> regions, MappingContext<? extends GemfirePersistentEntity<?>, GemfirePersistentProperty> context) {
        Assert.notNull(regions, (String)"Regions must not be null!");
        Assert.notNull(context, (String)"MappingContext must not be null!");
        this.context = context;
        this.regions = new Regions(regions, this.context);
    }

    public <T, ID extends Serializable> GemfireEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        GemfirePersistentEntity entity = (GemfirePersistentEntity)this.context.getPersistentEntity(domainClass);
        return new DefaultGemfireEntityInformation(entity);
    }

    protected Object getTargetRepository(RepositoryInformation repositoryInformation) {
        EntityInformation entityInformation = this.getEntityInformation(repositoryInformation.getDomainType());
        GemfireTemplate gemfireTemplate = this.getTemplate((RepositoryMetadata)repositoryInformation);
        return this.getTargetRepositoryViaReflection(repositoryInformation, new Object[]{gemfireTemplate, entityInformation});
    }

    private GemfireTemplate getTemplate(RepositoryMetadata metadata) {
        GemfirePersistentEntity entity = (GemfirePersistentEntity)this.context.getPersistentEntity(metadata.getDomainType());
        String entityRegionName = entity.getRegionName();
        String repositoryRegionName = this.getRepositoryRegionName(metadata.getRepositoryInterface());
        String regionName = StringUtils.hasText((String)repositoryRegionName) ? repositoryRegionName : entityRegionName;
        com.gemstone.gemfire.cache.Region region = this.regions.getRegion(regionName);
        if (region == null) {
            throw new IllegalStateException(String.format("No Region '%1$s' found for domain class %2$s! Make sure you have configured a GemFire Region of that name in your application context!", regionName, metadata.getDomainType()));
        }
        Class regionKeyType = region.getAttributes().getKeyConstraint();
        Class entityIdType = metadata.getIdType();
        if (regionKeyType != null && entity.getIdProperty() != null) {
            Assert.isTrue((boolean)regionKeyType.isAssignableFrom(entityIdType), (String)String.format("The Region referenced only supports keys of type %1$s but the entity to be stored has an id of type %2$s!", regionKeyType, entityIdType));
        }
        return new GemfireTemplate(region);
    }

    private String getRepositoryRegionName(Class<?> repositoryClass) {
        return repositoryClass.isAnnotationPresent(Region.class) ? repositoryClass.getAnnotation(Region.class).value() : null;
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleGemfireRepository.class;
    }

    protected QueryLookupStrategy getQueryLookupStrategy(QueryLookupStrategy.Key key) {
        return new QueryLookupStrategy(){

            public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
                GemfireQueryMethod queryMethod = new GemfireQueryMethod(method, metadata, factory, GemfireRepositoryFactory.this.context);
                GemfireTemplate template = GemfireRepositoryFactory.this.getTemplate(metadata);
                if (queryMethod.hasAnnotatedQuery()) {
                    return new StringBasedGemfireRepositoryQuery(queryMethod, template).asUserDefinedQuery();
                }
                String namedQueryName = queryMethod.getNamedQueryName();
                if (namedQueries.hasQuery(namedQueryName)) {
                    return new StringBasedGemfireRepositoryQuery(namedQueries.getQuery(namedQueryName), queryMethod, template).asUserDefinedQuery();
                }
                return new PartTreeGemfireRepositoryQuery(queryMethod, template);
            }
        };
    }
}

