/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.batch.mapreduce;

import java.io.IOException;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.SimpleSystemProcessExitCodeMapper;
import org.springframework.batch.core.step.tasklet.SystemProcessExitCodeMapper;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.hadoop.mapreduce.ToolExecutor;
import org.springframework.util.Assert;

public class ToolTasklet
extends ToolExecutor
implements Tasklet,
InitializingBean {
    private SystemProcessExitCodeMapper systemProcessExitCodeMapper = new SimpleSystemProcessExitCodeMapper();

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        int exitCode = this.runCode();
        if (this.systemProcessExitCodeMapper.getExitStatus(exitCode) == ExitStatus.FAILED) {
            throw new IOException("Hadoop tool failed with exit code: " + exitCode);
        }
        return RepeatStatus.FINISHED;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.systemProcessExitCodeMapper, (String)"SystemProcessExitCodeMapper must be set");
    }

    public void setSystemProcessExitCodeMapper(SystemProcessExitCodeMapper systemProcessExitCodeMapper) {
        this.systemProcessExitCodeMapper = systemProcessExitCodeMapper;
    }
}

