/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.codec;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.io.compress.BZip2Codec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.io.compress.SnappyCodec;
import org.springframework.data.hadoop.store.codec.CodecInfo;
import org.springframework.data.hadoop.store.codec.DefaultCodecInfo;

public enum Codecs {
    GZIP(new DefaultCodecInfo(GzipCodec.class.getName(), false, "gzip"), "GZIP"),
    SNAPPY(new DefaultCodecInfo(SnappyCodec.class.getName(), false, "snappy"), "SNAPPY"),
    BZIP2(new DefaultCodecInfo(BZip2Codec.class.getName(), true, "bzip2"), "BZIP2"),
    LZO(new DefaultCodecInfo("com.hadoop.compression.lzo.LzoCodec", false, "lzo"), "LZO"),
    SLZO(new DefaultCodecInfo("com.hadoop.compression.lzo.LzoCodec", true, "slzo"), "SLZO"),
    LZOP(new DefaultCodecInfo("com.hadoop.compression.lzo.LzopCodec", false, "lzop"), "LZOP"),
    SLZOP(new DefaultCodecInfo("com.hadoop.compression.lzo.LzopCodec", true, "slzop"), "SLZOP");

    private final CodecInfo codec;
    private final String[] abbreviations;
    private static final Map<String, Codecs> lookup;

    private Codecs(CodecInfo codec, String ... abbreviations) {
        this.codec = codec;
        this.abbreviations = abbreviations;
    }

    public CodecInfo getCodecInfo() {
        return this.codec;
    }

    public String getAbbreviation() {
        return this.abbreviations[0];
    }

    public String[] getAbbreviations() {
        return this.abbreviations;
    }

    public static Codecs get(String abbreviation) {
        return lookup.get(abbreviation.toLowerCase());
    }

    public static CodecInfo getCodecInfo(String abbreviation) {
        Codecs codecs = Codecs.get(abbreviation);
        return codecs != null ? codecs.getCodecInfo() : null;
    }

    static {
        lookup = new HashMap<String, Codecs>();
        for (Codecs c : Codecs.values()) {
            String[] array;
            for (String abbv : array = c.getAbbreviations()) {
                lookup.put(abbv.toLowerCase(), c);
            }
        }
    }
}

