/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.dataset;

import java.io.IOException;
import org.kitesdk.data.DatasetReader;
import org.springframework.data.hadoop.store.DataStoreReader;
import org.springframework.data.hadoop.store.StoreException;
import org.springframework.data.hadoop.store.dataset.DatasetDefinition;
import org.springframework.data.hadoop.store.dataset.DatasetRepositoryFactory;
import org.springframework.util.Assert;

public abstract class AbstractDatasetStoreReader<T, R>
implements DataStoreReader<T> {
    private Class<T> entityClass;
    private DatasetRepositoryFactory datasetRepositoryFactory;
    private DatasetDefinition datasetDefinition;
    protected volatile DatasetReader<R> reader;
    private boolean closed = false;

    protected AbstractDatasetStoreReader(Class<T> entityClass, DatasetRepositoryFactory datasetRepositoryFactory, DatasetDefinition datasetDefinition) {
        Assert.notNull(entityClass, (String)"You must specify 'entityClass'");
        Assert.notNull((Object)datasetRepositoryFactory, (String)"You must provide a 'datasetRepositoryFactory'");
        Assert.notNull((Object)datasetDefinition, (String)"You must provide a 'datasetDefinition'");
        this.entityClass = entityClass;
        this.datasetRepositoryFactory = datasetRepositoryFactory;
        this.datasetDefinition = datasetDefinition;
    }

    @Override
    public T read() throws IOException {
        if (this.closed) {
            throw new StoreException("Reader is already closed");
        }
        if (this.reader == null) {
            this.reader = this.createReader();
        }
        if (this.reader.hasNext()) {
            return this.convertEntity(this.reader.next());
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
            this.closed = true;
        }
    }

    protected Class<T> getEntityClass() {
        return this.entityClass;
    }

    protected DatasetRepositoryFactory getDatasetRepositoryFactory() {
        return this.datasetRepositoryFactory;
    }

    protected DatasetDefinition getDatasetDefinition() {
        return this.datasetDefinition;
    }

    protected abstract T convertEntity(R var1);

    protected abstract DatasetReader<R> createReader();
}

