/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.store.dataset;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.hadoop.store.support.IdleTimeoutTrigger;
import org.springframework.data.hadoop.store.support.LifecycleObjectSupport;
import org.springframework.data.hadoop.store.support.PollingTaskSupport;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;

public class DatasetStoreObjectSupport
extends LifecycleObjectSupport {
    private static final Log log = LogFactory.getLog(DatasetStoreObjectSupport.class);
    private IdleTimeoutPoller idlePoller;
    private volatile IdleTimeoutTrigger idleTrigger;
    private CloseTimeoutPoller closePoller;
    private volatile IdleTimeoutTrigger closeTrigger;
    private volatile long lastIdle = Long.MIN_VALUE;
    private volatile long idleTimeout;
    private volatile long closeTimeout;

    @Override
    protected void onInit() throws Exception {
        if (this.idleTimeout > 0L) {
            this.idleTrigger = new IdleTimeoutTrigger(this.idleTimeout);
            this.idlePoller = new IdleTimeoutPoller(this.getTaskScheduler(), this.getTaskExecutor(), this.idleTrigger);
            this.idlePoller.init();
        }
        if (this.closeTimeout > 0L) {
            this.closeTrigger = new IdleTimeoutTrigger(this.closeTimeout);
            this.closeTrigger.setInitialDelay(this.closeTimeout);
            this.closePoller = new CloseTimeoutPoller(this.getTaskScheduler(), this.getTaskExecutor(), this.closeTrigger);
            this.closePoller.init();
        }
    }

    @Override
    protected void doStart() {
        if (this.idlePoller != null) {
            this.idlePoller.start();
        }
        if (this.closePoller != null) {
            this.closePoller.start();
        }
    }

    @Override
    protected void doStop() {
        if (this.idlePoller != null) {
            this.idlePoller.stop();
        }
        this.idlePoller = null;
        if (this.closePoller != null) {
            this.closePoller.stop();
        }
        this.closePoller = null;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public void setCloseTimeout(long closeTimeout) {
        this.closeTimeout = closeTimeout;
    }

    public void resetIdleTimeout() {
        this.lastIdle = System.currentTimeMillis();
    }

    protected void handleIdleTimeout() {
    }

    private class CloseTimeoutPoller
    extends PollingTaskSupport<Void> {
        public CloseTimeoutPoller(TaskScheduler taskScheduler, TaskExecutor taskExecutor, Trigger trigger) {
            super(taskScheduler, taskExecutor, trigger);
        }

        @Override
        protected Void doPoll() {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Close timeout detected, calling handleIdleTimeout()");
                }
                DatasetStoreObjectSupport.this.handleIdleTimeout();
            }
            catch (Exception e) {
                log.error((Object)"error closing", (Throwable)e);
            }
            return null;
        }
    }

    private class IdleTimeoutPoller
    extends PollingTaskSupport<Boolean> {
        public IdleTimeoutPoller(TaskScheduler taskScheduler, TaskExecutor taskExecutor, Trigger trigger) {
            super(taskScheduler, taskExecutor, trigger);
        }

        @Override
        protected Boolean doPoll() {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Polling idle timeout with idleTimeout=" + DatasetStoreObjectSupport.this.idleTimeout + " lastIdle=" + DatasetStoreObjectSupport.this.lastIdle));
            }
            return DatasetStoreObjectSupport.this.idleTimeout > 0L && DatasetStoreObjectSupport.this.lastIdle > 0L && DatasetStoreObjectSupport.this.lastIdle + DatasetStoreObjectSupport.this.idleTimeout < System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onPollResult(Boolean result) {
            if (result.booleanValue()) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Idle timeout detected, calling handleIdleTimeout()");
                    }
                    DatasetStoreObjectSupport.this.handleIdleTimeout();
                }
                catch (Exception e) {
                    log.error((Object)"error closing", (Throwable)e);
                }
                finally {
                    DatasetStoreObjectSupport.this.lastIdle = Long.MIN_VALUE;
                }
            }
        }
    }
}

