/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.cascading;

import cascading.cascade.Cascade;
import cascading.cascade.CascadeConnector;
import cascading.cascade.CascadeProps;
import cascading.flow.Flow;
import cascading.flow.FlowSkipStrategy;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.hadoop.configuration.ConfigurationUtils;

public class CascadeFactoryBean
implements InitializingBean,
BeanNameAware,
FactoryBean<Cascade> {
    private Configuration configuration;
    private Properties properties;
    private FlowSkipStrategy skipStrategy;
    private Collection<Flow> flows;
    private int concurrentFlows = 0;
    private String beanName;
    private Cascade cascade;

    public Cascade getObject() throws Exception {
        return this.cascade;
    }

    public Class<?> getObjectType() {
        return this.cascade != null ? this.cascade.getClass() : Cascade.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        Properties props = ConfigurationUtils.asProperties(ConfigurationUtils.createFrom(this.configuration, this.properties));
        CascadeProps.setMaxConcurrentFlows((Map)props, (int)this.concurrentFlows);
        this.cascade = new CascadeConnector((Map)this.properties).connect(this.beanName, this.flows);
        if (this.skipStrategy != null) {
            this.cascade.setFlowSkipStrategy(this.skipStrategy);
        }
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setFlows(Collection<Flow> flows) {
        this.flows = flows;
    }
}

