/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.config;

import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.hadoop.config.NamespaceUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

abstract class AbstractImprovedSimpleBeanDefinitionParser
extends AbstractSimpleBeanDefinitionParser {
    AbstractImprovedSimpleBeanDefinitionParser() {
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String scope = element.getAttribute("scope");
        if (StringUtils.hasText((String)scope)) {
            builder.setScope(scope);
        }
        NamedNodeMap attributes = element.getAttributes();
        for (int x = 0; x < attributes.getLength(); ++x) {
            Attr attribute = (Attr)attributes.item(x);
            if (!this.isEligibleAttribute(attribute, parserContext)) continue;
            String attributeName = attribute.getLocalName();
            boolean isReference = NamespaceUtils.isReference(attributeName);
            String propertyName = this.extractPropertyName(isReference ? attributeName.substring(0, attributeName.length() - 4) : attributeName);
            Assert.state((boolean)StringUtils.hasText((String)propertyName), (String)"Illegal property name returned from 'extractPropertyName(String)': cannot be null or empty.");
            if (isReference) {
                builder.addPropertyReference(propertyName, attribute.getValue());
                continue;
            }
            builder.addPropertyValue(propertyName, (Object)attribute.getValue());
        }
        this.postProcess(builder, element);
    }

    protected void registerBeanDefinition(BeanDefinitionHolder definition, BeanDefinitionRegistry registry) {
        super.registerBeanDefinition(definition, registry);
    }

    protected boolean isEligibleAttribute(String attributeName) {
        return super.isEligibleAttribute(attributeName) && !"scope".equals(attributeName);
    }

    protected String defaultId(ParserContext context, Element element) {
        if (context != null) {
            context.getReaderContext().error("Id is required for element '" + context.getDelegate().getLocalName((Node)element) + "' when used as a top-level tag", (Object)element);
        }
        return null;
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String name = super.resolveId(element, definition, parserContext);
        if (!StringUtils.hasText((String)name)) {
            name = this.defaultId(parserContext, element);
        }
        return name;
    }

    private static String camelCaseToHyphenated(String camelCase) {
        Assert.notNull((Object)camelCase, (String)"'attributeName' must not be null");
        char[] chars = camelCase.toCharArray();
        StringBuilder sb = new StringBuilder(chars.length + 2);
        boolean upperCase = false;
        for (char c : chars) {
            if (Character.isUpperCase(c)) {
                if (!upperCase) {
                    sb.append("-");
                    c = Character.toLowerCase(c);
                    upperCase = true;
                }
            } else {
                upperCase = false;
            }
            sb.append(c);
        }
        return new String(sb);
    }
}

