/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.fs;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.data.hadoop.fs.HdfsResource;
import org.springframework.data.hadoop.fs.HdfsResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DistributedCacheFactoryBean
implements InitializingBean,
FactoryBean<DistributedCache> {
    private Configuration conf;
    private DistributedCache ds;
    private FileSystem fs;
    private boolean createSymlink = false;
    private Collection<CacheEntry> entries;

    public DistributedCache getObject() throws Exception {
        return this.ds;
    }

    public Class<?> getObjectType() {
        return DistributedCache.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.conf, (String)"A Hadoop configuration is required");
        Assert.notEmpty(this.entries, (String)"No entries specified");
        if (this.fs == null) {
            this.fs = FileSystem.get((Configuration)this.conf);
        }
        this.ds = new DistributedCache();
        if (this.createSymlink) {
            DistributedCache.createSymlink((Configuration)this.conf);
        }
        HdfsResourceLoader loader = new HdfsResourceLoader(this.conf);
        for (CacheEntry entry : this.entries) {
            Object[] resources = loader.getResources(entry.value);
            if (ObjectUtils.isEmpty((Object[])resources)) continue;
            block6: for (Object resource : resources) {
                HdfsResource res = (HdfsResource)resource;
                URI uri = res.getURI();
                String defaultLink = resource.getFilename();
                boolean isArchive = defaultLink.endsWith(".tgz") || defaultLink.endsWith(".tar") || defaultLink.endsWith(".tar.gz") || defaultLink.endsWith(".zip");
                switch (entry.type) {
                    case CP: {
                        Path p = res.getPath();
                        if (isArchive) {
                            DistributedCache.addArchiveToClassPath((Path)p, (Configuration)this.conf, (FileSystem)this.fs);
                            continue block6;
                        }
                        DistributedCache.addFileToClassPath((Path)p, (Configuration)this.conf, (FileSystem)this.fs);
                        continue block6;
                    }
                    case LOCAL: {
                        if (isArchive) {
                            DistributedCache.addLocalArchives((Configuration)this.conf, (String)uri.toString());
                            continue block6;
                        }
                        DistributedCache.addLocalFiles((Configuration)this.conf, (String)uri.toString());
                        continue block6;
                    }
                    case CACHE: {
                        if (!StringUtils.hasText((String)uri.getFragment())) {
                            uri = URI.create(uri.toString() + "#" + defaultLink);
                        }
                        if (isArchive) {
                            DistributedCache.addCacheArchive((URI)uri, (Configuration)this.conf);
                            continue block6;
                        }
                        DistributedCache.addCacheFile((URI)uri, (Configuration)this.conf);
                    }
                }
            }
        }
    }

    public void setEntries(Collection<CacheEntry> entries) {
        this.entries = entries;
    }

    public void setLocalEntries(Collection<Resource> resources) {
        this.setEntries(CacheEntry.EntryType.LOCAL, resources);
    }

    public void setCacheEntries(Collection<Resource> resources) {
        this.setEntries(CacheEntry.EntryType.CACHE, resources);
    }

    public void setClassPathEntries(Collection<Resource> resources) {
        this.setEntries(CacheEntry.EntryType.CP, resources);
    }

    private void setEntries(CacheEntry.EntryType cp, Collection<Resource> resources) {
        if (resources == null) {
            this.setEntries(null);
        } else {
            ArrayList<CacheEntry> entries = new ArrayList<CacheEntry>(resources.size());
            for (Resource resource : resources) {
                try {
                    entries.add(new CacheEntry(cp, resource.getURI().toString()));
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException("Cannot resolve resource " + resource, ex);
                }
            }
            this.setEntries(entries);
        }
    }

    public void setConfiguration(Configuration conf) {
        this.conf = conf;
    }

    public void setFileSystem(FileSystem fs) {
        this.fs = fs;
    }

    public void setCreateSymlink(boolean createSymlink) {
        this.createSymlink = createSymlink;
    }

    public static class CacheEntry {
        final EntryType type;
        final String value;

        public CacheEntry(EntryType type, String value) {
            this.type = type;
            this.value = value;
        }

        public static enum EntryType {
            LOCAL,
            CACHE,
            CP;

        }
    }
}

