/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.hbase;

import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTableInterfaceFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.hadoop.hbase.HbaseSynchronizationManager;
import org.springframework.data.hadoop.hbase.HbaseSystemException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class HbaseUtils {
    public static DataAccessException convertHbaseException(Exception ex) {
        return new HbaseSystemException(ex);
    }

    public static HTable getHTable(Configuration configuration, String tableName) {
        return HbaseUtils.getHTable(null, HbaseUtils.getCharset(null), configuration, tableName);
    }

    public static HTable getHTable(HTableInterfaceFactory tableFactory, Charset charset, Configuration configuration, String tableName) {
        if (HbaseSynchronizationManager.hasResource(tableName)) {
            return (HTable)HbaseSynchronizationManager.getResource(tableName);
        }
        HTable t = null;
        try {
            if (tableFactory != null) {
                HTableInterface table = tableFactory.createHTableInterface(configuration, tableName.getBytes(charset));
                Assert.isInstanceOf(HTable.class, (Object)table, (String)"The table factory needs to create HTable instances");
                t = (HTable)table;
            } else {
                t = new HTable(configuration, tableName.getBytes(charset));
            }
            return t;
        }
        catch (Exception ex) {
            throw HbaseUtils.convertHbaseException(ex);
        }
    }

    static Charset getCharset(String encoding) {
        return StringUtils.hasText((String)encoding) ? Charset.forName(encoding) : Charset.forName("UTF-8");
    }

    public static void releaseTable(String tableName, HTableInterface table) {
        try {
            HbaseUtils.doReleaseTable(tableName, table);
        }
        catch (IOException ex) {
            throw HbaseUtils.convertHbaseException(ex);
        }
    }

    private static void doReleaseTable(String tableName, HTableInterface table) throws IOException {
        if (table == null) {
            return;
        }
        if (!HbaseUtils.isBoundToThread(tableName)) {
            table.close();
        }
    }

    private static boolean isBoundToThread(String tableName) {
        return HbaseSynchronizationManager.hasResource(tableName);
    }
}

