/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.mapreduce;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapreduce.Job;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.data.hadoop.mapreduce.JobUtils;

class MapReducePropertyEditorRegistrar
implements PropertyEditorRegistrar {
    MapReducePropertyEditorRegistrar() {
    }

    public void registerCustomEditors(PropertyEditorRegistry registry) {
        registry.registerCustomEditor(RunningJob.class, (PropertyEditor)new BaseJobEditor(){

            @Override
            protected Object convert(Job job) {
                return JobUtils.getRunningJob(job);
            }
        });
        registry.registerCustomEditor(org.apache.hadoop.mapreduce.JobID.class, (PropertyEditor)new BaseJobEditor(){

            @Override
            protected Object convert(Job job) {
                return JobUtils.getJobId(job);
            }
        });
        registry.registerCustomEditor(JobID.class, (PropertyEditor)new BaseJobEditor(){

            @Override
            protected Object convert(Job job) {
                return JobUtils.getOldJobId(job);
            }
        });
        registry.registerCustomEditor(JobConf.class, (PropertyEditor)new BaseJobEditor(){

            @Override
            protected Object convert(Job job) {
                return JobUtils.getJobConf(job);
            }
        });
    }

    private static abstract class BaseJobEditor
    extends PropertyEditorSupport {
        private BaseJobEditor() {
        }

        @Override
        public void setAsText(String text) throws IllegalArgumentException {
            throw new IllegalArgumentException("this property editor works only with " + Job.class.getName());
        }

        @Override
        public String getAsText() {
            return null;
        }

        @Override
        public void setValue(Object value) {
            if (value == null) {
                super.setValue(null);
                return;
            }
            if (value instanceof Job) {
                super.setValue(this.convert((Job)value));
                return;
            }
            throw new IllegalArgumentException("expected a service of type " + Job.class.getName());
        }

        protected abstract Object convert(Job var1);
    }
}

