/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.pig;

import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.pig.PigException;
import org.apache.pig.PigServer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.impl.PigContext;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.data.hadoop.pig.PigScript;
import org.springframework.data.hadoop.pig.PigServerFactory;
import org.springframework.data.hadoop.pig.PigUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class PigServerFactoryBean
implements FactoryBean<PigServerFactory>,
BeanNameAware {
    private PigContext pigContext;
    private Collection<String> pathToSkip;
    private Collection<PigScript> scripts;
    private Integer parallelism;
    private String jobName;
    private String jobPriority;
    private Boolean validateEachStatement;
    private String beanName;
    private String user;

    public PigServerFactory getObject() throws Exception {
        return new DefaultPigServerFactory();
    }

    public Class<?> getObjectType() {
        return PigServerFactory.class;
    }

    public boolean isSingleton() {
        return true;
    }

    protected PigServer createPigInstance() throws Exception {
        final PigContext ctx = this.pigContext != null ? this.pigContext : new PigContext();
        PigServer pigServer = null;
        try {
            if (StringUtils.hasText((String)this.user)) {
                UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)this.user, (UserGroupInformation)UserGroupInformation.getLoginUser());
                pigServer = (PigServer)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<PigServer>(){

                    @Override
                    public PigServer run() throws Exception {
                        return new PigServer(ctx, true);
                    }
                });
            } else {
                pigServer = new PigServer(ctx, true);
            }
        }
        catch (ExecException ex) {
            throw PigUtils.convert((PigException)ex);
        }
        if (!CollectionUtils.isEmpty(this.pathToSkip)) {
            for (String path : this.pathToSkip) {
                pigServer.addPathToSkip(path);
            }
        }
        if (this.parallelism != null) {
            pigServer.setDefaultParallel(this.parallelism.intValue());
        }
        if (StringUtils.hasText((String)this.jobName)) {
            pigServer.setJobName(this.jobName);
        } else if (StringUtils.hasText((String)this.beanName)) {
            pigServer.setJobName(this.beanName);
        }
        if (StringUtils.hasText((String)this.jobPriority)) {
            pigServer.setJobPriority(this.jobPriority);
        }
        if (this.validateEachStatement != null) {
            pigServer.setValidateEachStatement(this.validateEachStatement.booleanValue());
        }
        if (!CollectionUtils.isEmpty(this.scripts)) {
            PigUtils.runWithConversion(pigServer, this.scripts, false);
        }
        return pigServer;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setPigContext(PigContext pigContext) {
        this.pigContext = pigContext;
    }

    public void setPathsToSkip(Collection<String> pathToSkip) {
        this.pathToSkip = pathToSkip;
    }

    public void setScripts(Collection<PigScript> scripts) {
        this.scripts = scripts;
    }

    public void setParallelism(Integer parallelism) {
        this.parallelism = parallelism;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public void setJobPriority(String jobPriority) {
        this.jobPriority = jobPriority;
    }

    public void setValidateEachStatement(Boolean validateEachStatement) {
        this.validateEachStatement = validateEachStatement;
    }

    public void setUser(String user) {
        this.user = user;
    }

    private class DefaultPigServerFactory
    implements PigServerFactory {
        private DefaultPigServerFactory() {
        }

        @Override
        public PigServer getPigServer() {
            try {
                return PigServerFactoryBean.this.createPigInstance();
            }
            catch (Exception ex) {
                throw new BeanCreationException("Cannot create PigServer instance", (Throwable)ex);
            }
        }
    }
}

