/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.pig;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.IOUtils;
import org.apache.pig.PigException;
import org.apache.pig.PigServer;
import org.apache.pig.backend.BackendException;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.executionengine.ExecJob;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.JobCreationException;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.SchemaMergeException;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.tools.grunt.GruntParser;
import org.apache.pig.tools.parameters.ParameterSubstitutionPreprocessor;
import org.apache.pig.tools.pigscript.parser.ParseException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.dao.NonTransientDataAccessResourceException;
import org.springframework.data.hadoop.pig.PigScript;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

abstract class PigUtils {
    private static Class<?> PARSER_EXCEPTION;

    PigUtils() {
    }

    static DataAccessException convert(PigException ex) {
        if (ex instanceof BackendException) {
            return new DataAccessResourceFailureException("Backend Pig exception", (Throwable)ex);
        }
        if (ex instanceof VisitorException || ex instanceof PlanException || ex instanceof SchemaMergeException) {
            return new InvalidDataAccessResourceUsageException("Plan failed", (Throwable)ex);
        }
        if (ex instanceof FrontendException) {
            if (ex instanceof JobCreationException) {
                return new InvalidDataAccessResourceUsageException("Map Reduce error", (Throwable)ex);
            }
            if (PARSER_EXCEPTION != null && PARSER_EXCEPTION.isAssignableFrom(ex.getClass())) {
                return new InvalidDataAccessResourceUsageException("Syntax error", (Throwable)ex);
            }
        }
        return new NonTransientDataAccessResourceException("Unknown Pig error", (Throwable)ex);
    }

    static DataAccessException convert(IOException ex) {
        Throwable cause = ex.getCause();
        if (cause instanceof PigException) {
            return PigUtils.convert((PigException)ex);
        }
        return new NonTransientDataAccessResourceException("Unknown Pig error", (Throwable)ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<ExecJob> run(PigServer pig, Iterable<PigScript> scripts) throws ExecException, IOException {
        Assert.notNull(scripts, (String)"at least one script is required");
        if (!pig.isBatchOn()) {
            pig.setBatchOn();
        }
        ArrayList<ExecJob> jobs = new ArrayList<ExecJob>();
        pig.getPigContext().connect();
        InputStream in = null;
        try {
            for (PigScript script : scripts) {
                try {
                    in = script.getResource().getInputStream();
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException("Cannot open script [" + script.getResource() + "]", ex);
                }
                PigUtils.registerScript(pig, in, script.getArguments());
                jobs.addAll(pig.executeBatch());
            }
        }
        finally {
            IOUtils.closeStream(in);
        }
        return jobs;
    }

    static List<ExecJob> runWithConversion(PigServer pig, Iterable<PigScript> scripts, boolean closePig) throws DataAccessException {
        try {
            List<ExecJob> list = PigUtils.run(pig, scripts);
            return list;
        }
        catch (ExecException ex) {
            throw PigUtils.convert((PigException)ex);
        }
        catch (IOException ex) {
            throw PigUtils.convert(ex);
        }
        finally {
            if (closePig) {
                pig.shutdown();
            }
        }
    }

    private static void registerScript(PigServer pig, InputStream in, Map<String, String> arguments) throws IOException {
        Method registerScript = ReflectionUtils.findMethod(PigServer.class, (String)"registerScript", (Class[])new Class[]{InputStream.class, Map.class});
        if (registerScript != null) {
            ReflectionUtils.invokeMethod((Method)registerScript, (Object)pig, (Object[])new Object[]{in, arguments});
        } else {
            PigUtils.registerScriptForPig07X(pig, in, arguments);
        }
    }

    private static void registerScriptForPig07X(PigServer pig, InputStream in, Map<String, String> params) throws IOException {
        try {
            ArrayList<String> paramList = new ArrayList<String>();
            if (params != null) {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    paramList.add(entry.getKey() + "=" + entry.getValue());
                }
            }
            ParameterSubstitutionPreprocessor psp = new ParameterSubstitutionPreprocessor(50);
            StringWriter writer = new StringWriter();
            psp.genSubstitutedFile(new BufferedReader(new InputStreamReader(in)), (Writer)writer, null, null);
            GruntParser grunt = new GruntParser((Reader)new StringReader(writer.toString()));
            grunt.setInteractive(false);
            grunt.setParams(pig);
            grunt.parseStopOnError(true);
        }
        catch (FileNotFoundException e) {
            LogFactory.getLog(PigServer.class).error((Object)e.getLocalizedMessage());
            throw new IOException(e.getCause());
        }
        catch (ParseException e) {
            LogFactory.getLog(PigServer.class).error((Object)e.getLocalizedMessage());
            throw new IOException(e.getCause());
        }
        catch (org.apache.pig.tools.parameters.ParseException e) {
            LogFactory.getLog(PigServer.class).error((Object)e.getLocalizedMessage());
            throw new IOException(e.getCause());
        }
    }

    static void validateEachStatement(PigServer pig, boolean validate) {
        Method validateMethod = ReflectionUtils.findMethod(PigServer.class, (String)"setValidateEachStatement", (Class[])new Class[]{Boolean.TYPE});
        if (validateMethod != null) {
            ReflectionUtils.invokeMethod((Method)validateMethod, (Object)pig, (Object[])new Object[]{validate});
        }
    }

    static {
        Class cls = null;
        try {
            cls = ClassUtils.resolveClassName((String)"org.apache.pig.parser.ParserException", (ClassLoader)PigUtils.class.getClassLoader());
        }
        catch (Exception exception) {
            // empty catch block
        }
        PARSER_EXCEPTION = cls;
    }
}

