/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.configuration;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.GenericOptionsParser;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class ConfigurationUtils {
    public static void addProperties(Configuration configuration, Properties properties) {
        Assert.notNull((Object)configuration, (String)"A non-null configuration is required");
        if (properties != null) {
            Enumeration<?> props = properties.propertyNames();
            while (props.hasMoreElements()) {
                String key = props.nextElement().toString();
                configuration.set(key, properties.getProperty(key));
            }
        }
    }

    public static Configuration createFrom(Configuration original, Properties properties) {
        Object cfg = null;
        cfg = original != null ? (original instanceof JobConf ? new JobConf(original) : new Configuration(original)) : new JobConf();
        ConfigurationUtils.addProperties((Configuration)cfg, properties);
        return cfg;
    }

    public static JobConf createFrom(JobConf original, Properties properties) {
        return (JobConf)ConfigurationUtils.createFrom((Configuration)original, properties);
    }

    public static Properties asProperties(Configuration configuration) {
        Properties props = new Properties();
        if (configuration != null) {
            for (Map.Entry entry : configuration) {
                props.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return props;
    }

    public static Configuration merge(Configuration one, Configuration two) {
        if (one == null) {
            if (two == null) {
                return new JobConf();
            }
            return new JobConf(two);
        }
        JobConf c = new JobConf(one);
        if (two == null) {
            return c;
        }
        for (Map.Entry entry : two) {
            c.set((String)entry.getKey(), (String)entry.getValue());
        }
        return c;
    }

    public static void addLibs(Configuration configuration, Resource ... libs) {
        ConfigurationUtils.addResource(configuration, libs, "-libjars");
    }

    public static void addFiles(Configuration configuration, Resource ... files) {
        ConfigurationUtils.addResource(configuration, files, "-files");
    }

    public static void addArchives(Configuration configuration, Resource ... archives) {
        ConfigurationUtils.addResource(configuration, archives, "-archives");
    }

    private static void addResource(Configuration cfg, Resource[] args, String name) {
        Assert.notNull((Object)cfg, (String)"a non-null configuration is required");
        ArrayList<String> list = new ArrayList<String>();
        try {
            if (!ObjectUtils.isEmpty((Object[])args)) {
                int count = args.length;
                list.add(name);
                StringBuilder sb = new StringBuilder();
                for (Resource res : args) {
                    sb.append(res.getURI().toString());
                    if (--count <= 0) continue;
                    sb.append(",");
                }
                list.add(sb.toString());
            }
            new GenericOptionsParser(cfg, list.toArray(new String[list.size()]));
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

