/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.cascading.tap.local;

import cascading.flow.FlowProcess;
import cascading.scheme.Scheme;
import cascading.tap.SourceTap;
import cascading.tuple.TupleEntryIterator;
import cascading.tuple.TupleEntrySchemeIterator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.springframework.data.hadoop.cascading.tap.local.MessageSourceInputStream;
import org.springframework.data.hadoop.cascading.tap.local.TransformingMessageSource;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.transformer.Transformer;

public class MessageSourceTap
extends SourceTap<Properties, InputStream> {
    private InputStream source;

    public MessageSourceTap(Scheme<Properties, InputStream, ?, ?, ?> scheme, MessageSource<byte[]> source) {
        super(scheme);
        this.source = new MessageSourceInputStream(source);
    }

    public MessageSourceTap(Scheme<Properties, InputStream, ?, ?, ?> scheme, MessageSource<?> source, Transformer transformer) {
        this(scheme, new TransformingMessageSource<byte[]>(source, transformer));
    }

    public String getIdentifier() {
        return this.source.toString();
    }

    public TupleEntryIterator openForRead(FlowProcess<Properties> flowProcess, InputStream input) throws IOException {
        InputStream in = input == null ? this.source : input;
        return new TupleEntrySchemeIterator(flowProcess, this.getScheme(), (Object)in, this.getIdentifier());
    }

    public boolean resourceExists(Properties conf) throws IOException {
        return true;
    }

    public long getModifiedTime(Properties conf) throws IOException {
        return 0L;
    }
}

