/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.fs;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

class PrettyPrintMap<K, V>
extends LinkedHashMap<K, V> {
    final MapPrinter<K, V> printer;

    PrettyPrintMap(int size, MapPrinter<K, V> printer) {
        super(size);
        this.printer = printer;
    }

    @Override
    public String toString() {
        Iterator i = this.entrySet().iterator();
        if (!i.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        try {
            while (true) {
                Map.Entry e = i.next();
                sb.append(this.printer.toString(e.getKey(), e.getValue()));
                if (!i.hasNext()) {
                    return sb.toString();
                }
                sb.append("\n");
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot create String representation", ex);
        }
    }

    static interface MapPrinter<K, V> {
        public String toString(K var1, V var2) throws Exception;
    }
}

