/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.mapreduce;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.data.hadoop.configuration.ConfigurationUtils;

abstract class JobGenericOptions {
    final Log log = LogFactory.getLog(this.getClass());
    Resource[] files;
    Resource[] libJars;
    Resource[] archives;
    String user;

    JobGenericOptions() {
    }

    public void setLibs(Resource ... libJars) {
        this.libJars = libJars;
    }

    public void setFiles(Resource ... files) {
        this.files = files;
    }

    public void setArchives(Resource ... archives) {
        this.archives = archives;
    }

    void buildGenericOptions(Configuration cfg) {
        cfg.setBoolean("mapred.used.genericoptionsparser", true);
        ConfigurationUtils.addFiles(cfg, this.files);
        ConfigurationUtils.addLibs(cfg, this.libJars);
        ConfigurationUtils.addArchives(cfg, this.archives);
    }

    public void setUser(String user) {
        this.user = user;
    }
}

