/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.mapreduce;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;

class ParentLastURLClassLoader
extends URLClassLoader {
    private final ClassLoader system;

    public ParentLastURLClassLoader(URL[] classpath, ClassLoader parent) {
        super(classpath, parent);
        ClassLoader sys = ParentLastURLClassLoader.getSystemClassLoader();
        while (sys.getParent() != null) {
            sys = sys.getParent();
        }
        this.system = sys;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            if (this.system != null) {
                try {
                    c = this.system.loadClass(name);
                }
                catch (ClassNotFoundException ignored) {
                    // empty catch block
                }
            }
            if (c == null) {
                try {
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    c = super.loadClass(name, resolve);
                }
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    public URL getResource(String name) {
        URL url = null;
        if (this.system != null) {
            url = this.system.getResource(name);
        }
        if (url == null && (url = this.findResource(name)) == null) {
            url = super.getResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (this.system != null) {
            urls.addAll(Collections.list(this.system.getResources(name)));
        }
        urls.addAll(Collections.list(this.findResources(name)));
        ClassLoader parent = this.getParent();
        if (parent != null) {
            urls.addAll(Collections.list(parent.getResources(name)));
        }
        return Collections.enumeration(urls);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ParentLastURLCL\r\nURLs: ");
        sb.append(Arrays.asList(this.getURLs()));
        sb.append("\nParent CL: ");
        sb.append(this.getParent());
        sb.append("\nSystem CL: ");
        sb.append(this.system);
        sb.append("\n");
        return sb.toString();
    }
}

