/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.mapreduce;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.springframework.data.hadoop.mapreduce.HadoopCodeExecutor;
import org.springframework.util.Assert;

abstract class ToolExecutor
extends HadoopCodeExecutor<Tool> {
    ToolExecutor() {
    }

    protected Integer invokeTargetObject(Configuration cfg, Tool target, Class<Tool> targetClass, String[] args) throws Exception {
        return ToolRunner.run((Configuration)cfg, (Tool)target, (String[])args);
    }

    @Override
    protected Class<Tool> loadClass(String className, ClassLoader cl) {
        Class<Tool> clazz = super.loadClass(className, cl);
        Assert.isAssignable(Tool.class, clazz, (String)("Class [" + clazz + "] is not a Tool instance."));
        return clazz;
    }

    public void setTool(Tool tool) {
        Assert.isNull((Object)this.targetClassName, (String)"a Tool class already set");
        this.setTargetObject(tool);
    }

    public void setToolClass(String toolClassName) {
        Assert.isNull((Object)this.target, (String)"a Tool instance already set");
        this.setTargetClassName(toolClassName);
    }
}

