/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.config.common.annotation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.hadoop.config.common.annotation.AbstractAnnotationBuilder;
import org.springframework.data.hadoop.config.common.annotation.AnnotationBuilder;
import org.springframework.data.hadoop.config.common.annotation.AnnotationConfigurer;
import org.springframework.data.hadoop.config.common.annotation.AnnotationConfigurerAdapter;
import org.springframework.data.hadoop.config.common.annotation.ObjectPostProcessor;
import org.springframework.util.Assert;

public abstract class AbstractConfiguredAnnotationBuilder<O, I, B extends AnnotationBuilder<O>>
extends AbstractAnnotationBuilder<O> {
    private static final Log log = LogFactory.getLog(AbstractConfiguredAnnotationBuilder.class);
    private final LinkedHashMap<Class<? extends AnnotationConfigurer<O, B>>, List<AnnotationConfigurer<O, B>>> mainConfigurers = new LinkedHashMap();
    private final LinkedHashMap<Class<? extends AnnotationConfigurer<O, B>>, List<AnnotationConfigurer<O, B>>> postConfigurers = new LinkedHashMap();
    private final Map<Class<Object>, Object> sharedObjects = new HashMap<Class<Object>, Object>();
    private final boolean allowConfigurersOfSameType;
    private BuildState buildState = BuildState.UNBUILT;
    private ObjectPostProcessor<Object> objectPostProcessor;

    protected AbstractConfiguredAnnotationBuilder() {
        this(ObjectPostProcessor.QUIESCENT_POSTPROCESSOR);
    }

    protected AbstractConfiguredAnnotationBuilder(ObjectPostProcessor<Object> objectPostProcessor) {
        this(objectPostProcessor, false);
    }

    protected AbstractConfiguredAnnotationBuilder(ObjectPostProcessor<Object> objectPostProcessor, boolean allowConfigurersOfSameType) {
        Assert.notNull(objectPostProcessor, (String)"objectPostProcessor cannot be null");
        this.objectPostProcessor = objectPostProcessor;
        this.allowConfigurersOfSameType = allowConfigurersOfSameType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final O doBuild() throws Exception {
        LinkedHashMap<Class<? extends AnnotationConfigurer<O, B>>, List<AnnotationConfigurer<O, B>>> linkedHashMap = this.mainConfigurers;
        synchronized (linkedHashMap) {
            this.buildState = BuildState.INITIALIZING_MAINS;
            this.beforeInit();
            this.initMainConfigurers();
            this.buildState = BuildState.CONFIGURING_MAINS;
            this.beforeConfigureMains();
            this.configureMainConfigurers();
            this.buildState = BuildState.CONFIGURING_POSTS;
            this.beforeConfigurePosts();
            this.configurePostConfigurers();
            this.buildState = BuildState.BUILDING;
            O result = this.performBuild();
            this.buildState = BuildState.BUILT;
            return result;
        }
    }

    public O getOrBuild() {
        if (this.isUnbuilt()) {
            try {
                return this.build();
            }
            catch (Exception e) {
                log.error((Object)"Failed to perform build. Returning null", (Throwable)e);
                return null;
            }
        }
        return this.getObject();
    }

    public <C extends AnnotationConfigurerAdapter<O, I, B>> C apply(C configurer) throws Exception {
        this.add(configurer);
        configurer.addObjectPostProcessor(this.objectPostProcessor);
        configurer.setBuilder((AbstractConfiguredAnnotationBuilder)this);
        return configurer;
    }

    public <C extends AnnotationConfigurerAdapter<O, I, B>> C getOrApply(C configurer) throws Exception {
        AnnotationConfigurerAdapter existing = (AnnotationConfigurerAdapter)this.getConfigurer(configurer.getClass());
        if (existing != null) {
            return (C)existing;
        }
        return this.apply(configurer);
    }

    public <C extends AnnotationConfigurer<O, B>> C apply(C configurer) throws Exception {
        this.add(configurer);
        return configurer;
    }

    public <C> void setSharedObject(Class<C> sharedType, C object) {
        this.sharedObjects.put(sharedType, object);
    }

    public <C> C getSharedObject(Class<C> sharedType) {
        return (C)this.sharedObjects.get(sharedType);
    }

    public Map<Class<Object>, Object> getSharedObjects() {
        return Collections.unmodifiableMap(this.sharedObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <C extends AnnotationConfigurer<O, B>> void add(C configurer) throws Exception {
        Assert.notNull(configurer, (String)"configurer cannot be null");
        Class<?> clazz = configurer.getClass();
        if (!this.buildState.isConfigured()) {
            LinkedHashMap<Class<? extends AnnotationConfigurer<O, B>>, List<AnnotationConfigurer<O, B>>> linkedHashMap = this.mainConfigurers;
            synchronized (linkedHashMap) {
                List<AnnotationConfigurer<O, B>> configs;
                List<AnnotationConfigurer<O, B>> list = configs = this.allowConfigurersOfSameType ? this.mainConfigurers.get(clazz) : null;
                if (configs == null) {
                    configs = new ArrayList<AnnotationConfigurer<O, B>>(1);
                }
                configs.add(configurer);
                this.mainConfigurers.put(clazz, configs);
                if (this.buildState.isInitializing()) {
                    configurer.init((AbstractConfiguredAnnotationBuilder)this);
                }
            }
        }
        LinkedHashMap<Class<? extends AnnotationConfigurer<O, B>>, List<AnnotationConfigurer<O, B>>> linkedHashMap = this.postConfigurers;
        synchronized (linkedHashMap) {
            List<AnnotationConfigurer<O, B>> configs;
            List<AnnotationConfigurer<O, B>> list = configs = this.allowConfigurersOfSameType ? this.postConfigurers.get(clazz) : null;
            if (configs == null) {
                configs = new ArrayList<AnnotationConfigurer<O, B>>(1);
            }
            configs.add(configurer);
            this.postConfigurers.put(clazz, configs);
            configurer.init((AbstractConfiguredAnnotationBuilder)this);
        }
    }

    public <C extends AnnotationConfigurer<O, B>> List<C> getConfigurers(Class<C> clazz) {
        List<AnnotationConfigurer<O, B>> configs = this.mainConfigurers.get(clazz);
        if (configs == null) {
            return new ArrayList();
        }
        return new ArrayList<AnnotationConfigurer<O, B>>(configs);
    }

    public <C extends AnnotationConfigurer<O, B>> List<C> removeConfigurers(Class<C> clazz) {
        List configs = (List)this.mainConfigurers.remove(clazz);
        if (configs == null) {
            return new ArrayList();
        }
        return new ArrayList(configs);
    }

    public <C extends AnnotationConfigurer<O, B>> C getConfigurer(Class<C> clazz) {
        List<AnnotationConfigurer<O, B>> configs = this.mainConfigurers.get(clazz);
        if (configs == null) {
            return null;
        }
        if (configs.size() != 1) {
            throw new IllegalStateException("Only one configurer expected for type " + clazz + ", but got " + configs);
        }
        return (C)configs.get(0);
    }

    public <C extends AnnotationConfigurer<O, B>> C removeConfigurer(Class<C> clazz) {
        List configs = (List)this.mainConfigurers.remove(clazz);
        if (configs == null) {
            return null;
        }
        if (configs.size() != 1) {
            throw new IllegalStateException("Only one configurer expected for type " + clazz + ", but got " + configs);
        }
        return (C)((AnnotationConfigurer)configs.get(0));
    }

    public O objectPostProcessor(ObjectPostProcessor<Object> objectPostProcessor) {
        Assert.notNull(objectPostProcessor, (String)"objectPostProcessor cannot be null");
        this.objectPostProcessor = objectPostProcessor;
        return (O)this;
    }

    protected <P> P postProcess(P object) {
        return this.objectPostProcessor.postProcess(object);
    }

    protected void beforeInit() throws Exception {
    }

    protected void beforeConfigureMains() throws Exception {
    }

    protected void beforeConfigurePosts() throws Exception {
    }

    protected abstract O performBuild() throws Exception;

    private void initMainConfigurers() throws Exception {
        for (AnnotationConfigurer<O, AbstractConfiguredAnnotationBuilder> annotationConfigurer : this.getMainConfigurers()) {
            annotationConfigurer.init(this);
        }
    }

    private void configureMainConfigurers() throws Exception {
        for (AnnotationConfigurer<O, AbstractConfiguredAnnotationBuilder> annotationConfigurer : this.getMainConfigurers()) {
            annotationConfigurer.configure(this);
        }
    }

    private void configurePostConfigurers() throws Exception {
        for (AnnotationConfigurer<O, AbstractConfiguredAnnotationBuilder> annotationConfigurer : this.getPostConfigurers()) {
            annotationConfigurer.configure(this);
        }
    }

    private Collection<AnnotationConfigurer<O, B>> getMainConfigurers() {
        ArrayList<AnnotationConfigurer<O, B>> result = new ArrayList<AnnotationConfigurer<O, B>>();
        for (List<AnnotationConfigurer<O, B>> configs : this.mainConfigurers.values()) {
            result.addAll(configs);
        }
        return result;
    }

    private Collection<AnnotationConfigurer<O, B>> getPostConfigurers() {
        ArrayList<AnnotationConfigurer<O, B>> result = new ArrayList<AnnotationConfigurer<O, B>>();
        for (List<AnnotationConfigurer<O, B>> configs : this.postConfigurers.values()) {
            result.addAll(configs);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUnbuilt() {
        LinkedHashMap<Class<? extends AnnotationConfigurer<O, B>>, List<AnnotationConfigurer<O, B>>> linkedHashMap = this.mainConfigurers;
        synchronized (linkedHashMap) {
            return this.buildState == BuildState.UNBUILT;
        }
    }

    private static enum BuildState {
        UNBUILT(0),
        INITIALIZING_MAINS(1),
        CONFIGURING_MAINS(2),
        CONFIGURING_POSTS(3),
        BUILDING(4),
        BUILT(5);

        private final int order;

        private BuildState(int order) {
            this.order = order;
        }

        public boolean isInitializing() {
            return BuildState.INITIALIZING_MAINS.order == this.order;
        }

        public boolean isConfigured() {
            return this.order >= BuildState.CONFIGURING_MAINS.order;
        }
    }
}

