/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jdbc.core.convert.AggregateReader;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.ReadingDataAccessStrategy;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.query.Query;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

class SingleQueryDataAccessStrategy
implements ReadingDataAccessStrategy {
    private final RelationalMappingContext mappingContext;
    private final AggregateReader aggregateReader;

    public SingleQueryDataAccessStrategy(Dialect dialect, JdbcConverter converter, NamedParameterJdbcOperations jdbcTemplate) {
        this.mappingContext = converter.getMappingContext();
        this.aggregateReader = new AggregateReader(dialect, converter, jdbcTemplate);
    }

    @Override
    public <T> T findById(Object id, Class<T> domainType) {
        return this.aggregateReader.findById(id, this.getPersistentEntity(domainType));
    }

    public <T> List<T> findAll(Class<T> domainType) {
        return this.aggregateReader.findAll(this.getPersistentEntity(domainType));
    }

    public <T> List<T> findAllById(Iterable<?> ids, Class<T> domainType) {
        return this.aggregateReader.findAllById(ids, this.getPersistentEntity(domainType));
    }

    public <T> List<T> findAll(Class<T> domainType, Sort sort) {
        throw new UnsupportedOperationException();
    }

    public <T> List<T> findAll(Class<T> domainType, Pageable pageable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> Optional<T> findOne(Query query, Class<T> domainType) {
        return Optional.ofNullable(this.aggregateReader.findOne(query, this.getPersistentEntity(domainType)));
    }

    public <T> List<T> findAll(Query query, Class<T> domainType) {
        return this.aggregateReader.findAll(query, this.getPersistentEntity(domainType));
    }

    public <T> List<T> findAll(Query query, Class<T> domainType, Pageable pageable) {
        throw new UnsupportedOperationException();
    }

    private <T> RelationalPersistentEntity<T> getPersistentEntity(Class<T> domainType) {
        return (RelationalPersistentEntity)this.mappingContext.getRequiredPersistentEntity(domainType);
    }
}

