/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.lang.reflect.Array;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.sql.SQLType;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.jdbc.core.convert.AggregateReferenceConverters;
import org.springframework.data.jdbc.core.convert.ArrayUtils;
import org.springframework.data.jdbc.core.convert.Identifier;
import org.springframework.data.jdbc.core.convert.IterableOfEntryToMapConverter;
import org.springframework.data.jdbc.core.convert.JdbcColumnTypes;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.JdbcCustomConversions;
import org.springframework.data.jdbc.core.convert.JdbcTypeFactory;
import org.springframework.data.jdbc.core.convert.RelationResolver;
import org.springframework.data.jdbc.core.mapping.AggregateReference;
import org.springframework.data.jdbc.core.mapping.JdbcValue;
import org.springframework.data.jdbc.support.JdbcUtil;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.model.ValueExpressionEvaluator;
import org.springframework.data.relational.core.conversion.MappingRelationalConverter;
import org.springframework.data.relational.core.conversion.ObjectPath;
import org.springframework.data.relational.core.conversion.RelationalConverter;
import org.springframework.data.relational.core.conversion.RowDocumentAccessor;
import org.springframework.data.relational.core.mapping.AggregatePath;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.domain.RowDocument;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class MappingJdbcConverter
extends MappingRelationalConverter
implements JdbcConverter,
ApplicationContextAware {
    private static final Log LOG = LogFactory.getLog(MappingJdbcConverter.class);
    private static final Converter<Iterable<?>, Map<?, ?>> ITERABLE_OF_ENTRY_TO_MAP_CONVERTER = new IterableOfEntryToMapConverter();
    private final JdbcTypeFactory typeFactory;
    private final RelationResolver relationResolver;

    public MappingJdbcConverter(RelationalMappingContext context, RelationResolver relationResolver) {
        super(context, (CustomConversions)new JdbcCustomConversions());
        Assert.notNull((Object)relationResolver, (String)"RelationResolver must not be null");
        this.typeFactory = JdbcTypeFactory.unsupported();
        this.relationResolver = relationResolver;
        this.registerAggregateReferenceConverters();
    }

    public MappingJdbcConverter(RelationalMappingContext context, RelationResolver relationResolver, CustomConversions conversions, JdbcTypeFactory typeFactory) {
        super(context, conversions);
        Assert.notNull((Object)typeFactory, (String)"JdbcTypeFactory must not be null");
        Assert.notNull((Object)relationResolver, (String)"RelationResolver must not be null");
        this.typeFactory = typeFactory;
        this.relationResolver = relationResolver;
        this.registerAggregateReferenceConverters();
    }

    private void registerAggregateReferenceConverters() {
        ConverterRegistry registry = (ConverterRegistry)this.getConversionService();
        AggregateReferenceConverters.getConvertersToRegister(this.getConversionService()).forEach(arg_0 -> ((ConverterRegistry)registry).addConverter(arg_0));
    }

    @Nullable
    private Class<?> getEntityColumnType(TypeInformation<?> type) {
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.getMappingContext().getPersistentEntity(type);
        if (persistentEntity == null) {
            return null;
        }
        RelationalPersistentProperty idProperty = (RelationalPersistentProperty)persistentEntity.getIdProperty();
        if (idProperty == null) {
            return null;
        }
        return this.getColumnType(idProperty);
    }

    private Class<?> getReferenceColumnType(RelationalPersistentProperty property) {
        Class componentType = property.getTypeInformation().getRequiredComponentType().getType();
        RelationalPersistentEntity referencedEntity = (RelationalPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(componentType);
        return this.getColumnType((RelationalPersistentProperty)referencedEntity.getRequiredIdProperty());
    }

    @Override
    public SQLType getTargetSqlType(RelationalPersistentProperty property) {
        return JdbcUtil.targetSqlTypeFor(this.getColumnType(property));
    }

    @Override
    public Class<?> getColumnType(RelationalPersistentProperty property) {
        return this.doGetColumnType(property);
    }

    private Class<?> doGetColumnType(RelationalPersistentProperty property) {
        Class<?> columnType;
        if (property.isAssociation()) {
            return this.getReferenceColumnType(property);
        }
        if (property.isEntity() && (columnType = this.getEntityColumnType(property.getTypeInformation().getActualType())) != null) {
            return columnType;
        }
        Class<?> componentColumnType = JdbcColumnTypes.INSTANCE.resolvePrimitiveType(property.getActualType());
        while (componentColumnType.isArray()) {
            componentColumnType = componentColumnType.getComponentType();
        }
        if (property.isCollectionLike() && !property.isEntity()) {
            return Array.newInstance(componentColumnType, 0).getClass();
        }
        return componentColumnType;
    }

    @Nullable
    public Object readValue(@Nullable Object value, TypeInformation<?> type) {
        if (value == null) {
            return value;
        }
        if (value instanceof java.sql.Array) {
            java.sql.Array array = (java.sql.Array)value;
            try {
                return super.readValue(array.getArray(), type);
            }
            catch (SQLException | ConverterNotFoundException e) {
                LOG.info((Object)"Failed to extract a value of type %s from an Array; Attempting to use standard conversions", e);
            }
        }
        return super.readValue(value, type);
    }

    @Nullable
    public Object writeValue(@Nullable Object value, TypeInformation<?> type) {
        if (value == null) {
            return null;
        }
        return super.writeValue(value, type);
    }

    private boolean canWriteAsJdbcValue(@Nullable Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof AggregateReference) {
            AggregateReference aggregateReference = (AggregateReference)value;
            return this.canWriteAsJdbcValue(aggregateReference.getId());
        }
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.getMappingContext().getPersistentEntity(value.getClass());
        if (persistentEntity != null) {
            Object id = persistentEntity.getIdentifierAccessor(value).getIdentifier();
            return this.canWriteAsJdbcValue(id);
        }
        if (value instanceof JdbcValue) {
            return true;
        }
        Optional customWriteTarget = this.getConversions().getCustomWriteTarget(value.getClass());
        return customWriteTarget.isPresent() && ((Class)customWriteTarget.get()).isAssignableFrom(JdbcValue.class);
    }

    @Override
    public JdbcValue writeJdbcValue(@Nullable Object value, TypeInformation<?> columnType, SQLType sqlType) {
        TypeInformation targetType = this.canWriteAsJdbcValue(value) ? TypeInformation.of(JdbcValue.class) : columnType;
        Object convertedValue = this.writeValue(value, targetType);
        if (convertedValue instanceof JdbcValue) {
            JdbcValue result = (JdbcValue)convertedValue;
            return result;
        }
        if (convertedValue == null || !convertedValue.getClass().isArray()) {
            return JdbcValue.of(convertedValue, sqlType);
        }
        Class<?> componentType = convertedValue.getClass().getComponentType();
        if (convertedValue.getClass().isArray()) {
            if (componentType != Byte.TYPE && componentType != Byte.class) {
                Object[] objectArray = MappingJdbcConverter.requireObjectArray(convertedValue);
                return JdbcValue.of(this.typeFactory.createArray(objectArray), JDBCType.ARRAY);
            }
            if (componentType == Byte.class) {
                convertedValue = ArrayUtils.toPrimitive((Byte[])convertedValue);
            }
            return JdbcValue.of(convertedValue, JDBCType.BINARY);
        }
        return JdbcValue.of(convertedValue, sqlType);
    }

    @Nullable
    protected Object unwrap(@Nullable Object convertedValue) {
        if (convertedValue instanceof JdbcValue) {
            JdbcValue jdbcValue = (JdbcValue)convertedValue;
            return jdbcValue.getValue();
        }
        return convertedValue;
    }

    @Override
    public <R> R readAndResolve(TypeInformation<R> type, RowDocument source, Identifier identifier) {
        RelationalPersistentEntity entity = (RelationalPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(type);
        AggregatePath path = this.getMappingContext().getAggregatePath(entity);
        Identifier identifierToUse = ResolvingRelationalPropertyValueProvider.potentiallyAppendIdentifier(identifier, entity, it -> source.get((Object)it.getColumnName().getReference()));
        ResolvingConversionContext context = new ResolvingConversionContext(this.getConversionContext(ObjectPath.ROOT), path, identifierToUse);
        return (R)this.readAggregate(context, source, entity.getTypeInformation());
    }

    protected MappingRelationalConverter.RelationalPropertyValueProvider newValueProvider(RowDocumentAccessor documentAccessor, ValueExpressionEvaluator evaluator, MappingRelationalConverter.ConversionContext context) {
        if (context instanceof ResolvingConversionContext) {
            ResolvingConversionContext rcc = (ResolvingConversionContext)context;
            MappingRelationalConverter.AggregatePathValueProvider delegate = (MappingRelationalConverter.AggregatePathValueProvider)super.newValueProvider(documentAccessor, evaluator, context);
            return new ResolvingRelationalPropertyValueProvider(delegate, documentAccessor, rcc, rcc.identifier());
        }
        return super.newValueProvider(documentAccessor, evaluator, context);
    }

    static Object[] requireObjectArray(Object source) {
        Assert.isTrue((boolean)source.getClass().isArray(), (String)"Source object is not an array");
        Class<?> componentType = source.getClass().getComponentType();
        if (componentType.isPrimitive()) {
            if (componentType == Boolean.TYPE) {
                return ArrayUtils.toObject((boolean[])source);
            }
            if (componentType == Byte.TYPE) {
                return ArrayUtils.toObject((byte[])source);
            }
            if (componentType == Character.TYPE) {
                return ArrayUtils.toObject((char[])source);
            }
            if (componentType == Double.TYPE) {
                return ArrayUtils.toObject((double[])source);
            }
            if (componentType == Float.TYPE) {
                return ArrayUtils.toObject((float[])source);
            }
            if (componentType == Integer.TYPE) {
                return ArrayUtils.toObject((int[])source);
            }
            if (componentType == Long.TYPE) {
                return ArrayUtils.toObject((long[])source);
            }
            if (componentType == Short.TYPE) {
                return ArrayUtils.toObject((short[])source);
            }
            throw new IllegalArgumentException("Unsupported component type: " + String.valueOf(componentType));
        }
        return (Object[])source;
    }

    class ResolvingRelationalPropertyValueProvider
    implements MappingRelationalConverter.RelationalPropertyValueProvider {
        private final MappingRelationalConverter.AggregatePathValueProvider delegate;
        private final RowDocumentAccessor accessor;
        private final ResolvingConversionContext context;
        private final Identifier identifier;

        private ResolvingRelationalPropertyValueProvider(MappingRelationalConverter.AggregatePathValueProvider delegate, RowDocumentAccessor accessor, ResolvingConversionContext context, Identifier identifier) {
            AggregatePath path = context.aggregatePath();
            this.delegate = delegate;
            this.accessor = accessor;
            this.context = context;
            this.identifier = path.isEntity() ? ResolvingRelationalPropertyValueProvider.potentiallyAppendIdentifier(identifier, path.getRequiredLeafEntity(), property -> delegate.getValue(path.append(property))) : identifier;
        }

        static Identifier potentiallyAppendIdentifier(Identifier base, RelationalPersistentEntity<?> entity, Function<RelationalPersistentProperty, Object> getter) {
            RelationalPersistentProperty idProperty;
            Object propertyValue;
            if (entity.hasIdProperty() && (propertyValue = getter.apply(idProperty = (RelationalPersistentProperty)entity.getRequiredIdProperty())) != null) {
                return base.withPart(idProperty.getColumnName(), propertyValue, idProperty.getType());
            }
            return base;
        }

        @Nullable
        public <T> T getPropertyValue(RelationalPersistentProperty property) {
            AggregatePath aggregatePath = this.context.aggregatePath();
            if (MappingJdbcConverter.this.getConversions().isSimpleType(property.getActualType())) {
                return (T)this.delegate.getValue(aggregatePath);
            }
            if (property.isEntity()) {
                if (property.isCollectionLike() || property.isMap()) {
                    Identifier identifierToUse = this.identifier;
                    AggregatePath idDefiningParentPath = aggregatePath.getIdDefiningParentPath();
                    if (idDefiningParentPath.hasIdProperty()) {
                        RelationalPersistentProperty identifier = idDefiningParentPath.getRequiredIdProperty();
                        AggregatePath idPath = idDefiningParentPath.append(identifier);
                        Object value = this.delegate.getValue(idPath);
                        Assert.state((value != null ? 1 : 0) != 0, (String)"Identifier value must not be null at this point");
                        identifierToUse = Identifier.of(aggregatePath.getTableInfo().reverseColumnInfo().name(), value, identifier.getActualType());
                    }
                    Iterable<Object> allByPath = MappingJdbcConverter.this.relationResolver.findAllByPath(identifierToUse, (PersistentPropertyPath<? extends RelationalPersistentProperty>)aggregatePath.getRequiredPersistentPropertyPath());
                    if (property.isCollectionLike()) {
                        return (T)allByPath;
                    }
                    if (property.isMap()) {
                        return (T)ITERABLE_OF_ENTRY_TO_MAP_CONVERTER.convert(allByPath);
                    }
                    Iterator<Object> iterator = allByPath.iterator();
                    if (iterator.hasNext()) {
                        return (T)iterator.next();
                    }
                    return null;
                }
                return (T)(this.hasValue(property) ? MappingJdbcConverter.this.readAggregate(this.context, this.accessor, property.getTypeInformation()) : null);
            }
            return (T)this.delegate.getValue(aggregatePath);
        }

        public boolean hasValue(RelationalPersistentProperty property) {
            if (property.isCollectionLike() && property.isEntity() || property.isMap()) {
                return true;
            }
            AggregatePath aggregatePath = this.context.aggregatePath();
            if (property.isEntity()) {
                RelationalPersistentEntity entity = (RelationalPersistentEntity)MappingJdbcConverter.this.getMappingContext().getRequiredPersistentEntity((PersistentProperty)property);
                if (entity.hasIdProperty()) {
                    RelationalPersistentProperty referenceId = (RelationalPersistentProperty)entity.getRequiredIdProperty();
                    AggregatePath toUse = aggregatePath.append(referenceId);
                    return this.delegate.hasValue(toUse);
                }
                return this.delegate.hasValue(aggregatePath.getTableInfo().reverseColumnInfo().alias());
            }
            return this.delegate.hasValue(aggregatePath);
        }

        public boolean hasNonEmptyValue(RelationalPersistentProperty property) {
            if (property.isCollectionLike() && property.isEntity() || property.isMap()) {
                return true;
            }
            AggregatePath aggregatePath = this.context.aggregatePath();
            if (property.isEntity()) {
                RelationalPersistentEntity entity = (RelationalPersistentEntity)MappingJdbcConverter.this.getMappingContext().getRequiredPersistentEntity((PersistentProperty)property);
                if (entity.hasIdProperty()) {
                    RelationalPersistentProperty referenceId = (RelationalPersistentProperty)entity.getRequiredIdProperty();
                    AggregatePath toUse = aggregatePath.append(referenceId);
                    return this.delegate.hasValue(toUse);
                }
                return this.delegate.hasValue(aggregatePath.getTableInfo().reverseColumnInfo().alias());
            }
            return this.delegate.hasNonEmptyValue(aggregatePath);
        }

        public MappingRelationalConverter.RelationalPropertyValueProvider withContext(MappingRelationalConverter.ConversionContext context) {
            return context == this.context ? this : new ResolvingRelationalPropertyValueProvider(this.delegate.withContext(context), this.accessor, (ResolvingConversionContext)context, this.identifier);
        }
    }

    private record ResolvingConversionContext(MappingRelationalConverter.ConversionContext delegate, AggregatePath aggregatePath, Identifier identifier) implements MappingRelationalConverter.ConversionContext
    {
        public <S> S convert(Object source, TypeInformation<? extends S> typeHint) {
            return (S)this.delegate.convert(source, typeHint);
        }

        public <S> S convert(Object source, TypeInformation<? extends S> typeHint, MappingRelationalConverter.ConversionContext context) {
            return (S)this.delegate.convert(source, typeHint, context);
        }

        public ResolvingConversionContext forProperty(String name) {
            RelationalPersistentProperty property = (RelationalPersistentProperty)this.aggregatePath.getRequiredLeafEntity().getRequiredPersistentProperty(name);
            return this.forProperty(property);
        }

        public ResolvingConversionContext forProperty(RelationalPersistentProperty property) {
            MappingRelationalConverter.ConversionContext nested = this.delegate.forProperty(property);
            return new ResolvingConversionContext(nested, this.aggregatePath.append(property), this.identifier);
        }

        public ResolvingConversionContext withPath(ObjectPath currentPath) {
            return new ResolvingConversionContext(this.delegate.withPath(currentPath), this.aggregatePath, this.identifier);
        }

        public ObjectPath getPath() {
            return this.delegate.getPath();
        }

        public CustomConversions getCustomConversions() {
            return this.delegate.getCustomConversions();
        }

        public RelationalConverter getSourceConverter() {
            return this.delegate.getSourceConverter();
        }
    }
}

