/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.persistence.LockModeType;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.interceptor.ExposeInvocationInterceptor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.support.LockMetadataProvider;
import org.springframework.data.repository.core.support.RepositoryProxyPostProcessor;
import org.springframework.transaction.support.TransactionSynchronizationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LockModeRepositoryPostProcessor implements RepositoryProxyPostProcessor
{
    INSTANCE;

    private static final Object NULL;

    public void postProcess(ProxyFactory factory) {
        factory.addAdvice((Advice)ExposeInvocationInterceptor.INSTANCE);
        factory.addAdvice((Advice)LockModePopulatingMethodIntercceptor.INSTANCE);
    }

    public LockMetadataProvider getLockMetadataProvider() {
        return ThreadBoundLockMetadata.INSTANCE;
    }

    static {
        NULL = new Object();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ThreadBoundLockMetadata implements LockMetadataProvider
    {
        INSTANCE;


        @Override
        public LockModeType getLockModeType() {
            MethodInvocation invocation = ExposeInvocationInterceptor.currentInvocation();
            Object lockModeType = TransactionSynchronizationManager.getResource((Object)invocation.getMethod());
            return lockModeType == NULL ? null : (LockModeType)lockModeType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LockModePopulatingMethodIntercceptor implements MethodInterceptor
    {
        INSTANCE;


        public Object invoke(MethodInvocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            Object lockInfo = TransactionSynchronizationManager.getResource((Object)method);
            if (lockInfo != null) {
                return invocation.proceed();
            }
            Lock annotation = method.getAnnotation(Lock.class);
            LockModeType lockMode = (LockModeType)AnnotationUtils.getValue((Annotation)annotation);
            TransactionSynchronizationManager.bindResource((Object)method, (Object)(lockMode == null ? NULL : lockMode));
            return invocation.proceed();
        }
    }
}

