/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import com.mysema.query.jpa.EclipseLinkTemplates;
import com.mysema.query.jpa.HQLTemplates;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.JPQLTemplates;
import com.mysema.query.jpa.OpenJPATemplates;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Order;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Path;
import com.mysema.query.types.path.EntityPathBase;
import com.mysema.query.types.path.PathBuilder;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.support.PersistenceProvider;
import org.springframework.data.querydsl.QSort;
import org.springframework.util.Assert;

public class Querydsl {
    private final EntityManager em;
    private final PersistenceProvider provider;
    private final PathBuilder<?> builder;

    public Querydsl(EntityManager em, PathBuilder<?> builder) {
        Assert.notNull((Object)em);
        Assert.notNull(builder);
        this.em = em;
        this.provider = PersistenceProvider.fromEntityManager(em);
        this.builder = builder;
    }

    public JPQLQuery createQuery() {
        switch (this.provider) {
            case ECLIPSELINK: {
                return new JPAQuery(this.em, (JPQLTemplates)EclipseLinkTemplates.DEFAULT);
            }
            case HIBERNATE: {
                return new JPAQuery(this.em, (JPQLTemplates)HQLTemplates.DEFAULT);
            }
            case OPEN_JPA: {
                return new JPAQuery(this.em, (JPQLTemplates)OpenJPATemplates.DEFAULT);
            }
        }
        return new JPAQuery(this.em);
    }

    public JPQLQuery createQuery(EntityPath<?> ... paths) {
        return (JPQLQuery)this.createQuery().from(paths);
    }

    public JPQLQuery applyPagination(Pageable pageable, JPQLQuery query) {
        if (pageable == null) {
            return query;
        }
        query.offset((long)pageable.getOffset());
        query.limit((long)pageable.getPageSize());
        return this.applySorting(pageable.getSort(), query);
    }

    public JPQLQuery applySorting(Sort sort, JPQLQuery query) {
        if (sort == null) {
            return query;
        }
        if (sort instanceof QSort) {
            return this.addOrderByFrom((QSort)sort, query);
        }
        return this.addOrderByFrom(sort, query);
    }

    private JPQLQuery addOrderByFrom(QSort qsort, JPQLQuery query) {
        return (JPQLQuery)query.orderBy(this.adjustOrderSpecifierIfNecessary(qsort.getOrderSpecifiers(), query));
    }

    private OrderSpecifier<?>[] adjustOrderSpecifierIfNecessary(List<OrderSpecifier<?>> originalOrderSpecifiers, JPQLQuery query) {
        Assert.notNull(originalOrderSpecifiers, (String)"Original order specifiers must not be null!");
        Assert.notNull((Object)query, (String)"Query must not be null!");
        boolean orderModificationNecessary = false;
        ArrayList<Object> modifiedOrderSpecifiers = new ArrayList<Object>();
        for (OrderSpecifier<?> order : originalOrderSpecifiers) {
            Path targetPath = ((Path)order.getTarget()).getMetadata().getParent();
            boolean targetPathRootIsEntityRoot = targetPath.getRoot().equals(this.builder.getRoot());
            boolean targetPathEqualsRootEnityPath = targetPath.toString().equals(this.builder.toString());
            if (!targetPathRootIsEntityRoot) {
                query.leftJoin((EntityPath)this.builder.get((String)targetPath.getMetadata().getElement()), targetPath);
            } else if (targetPathRootIsEntityRoot && !targetPathEqualsRootEnityPath) {
                PathBuilder joinPathBuilder = new PathBuilder(targetPath.getType(), targetPath.getMetadata().getElement().toString());
                query.leftJoin((EntityPath)targetPath, (Path)joinPathBuilder);
                OrderSpecifier modifiedOrder = new OrderSpecifier(order.getOrder(), (Expression)joinPathBuilder.get(((Path)order.getTarget()).getMetadata().getElement().toString()), order.getNullHandling());
                modifiedOrderSpecifiers.add(modifiedOrder);
                orderModificationNecessary = true;
                continue;
            }
            modifiedOrderSpecifiers.add(order);
        }
        return orderModificationNecessary ? modifiedOrderSpecifiers.toArray(new OrderSpecifier[modifiedOrderSpecifiers.size()]) : originalOrderSpecifiers.toArray(new OrderSpecifier[originalOrderSpecifiers.size()]);
    }

    private JPQLQuery addOrderByFrom(Sort sort, JPQLQuery query) {
        Assert.notNull((Object)sort, (String)"Sort must not be null!");
        Assert.notNull((Object)query, (String)"Query must not be null!");
        for (Sort.Order order : sort) {
            query.orderBy(new OrderSpecifier[]{this.toOrderSpecifier(order, query)});
        }
        return query;
    }

    private OrderSpecifier<?> toOrderSpecifier(Sort.Order order, JPQLQuery query) {
        Expression<?> property = this.createExpressionAndPotentionallyAddLeftJoinForReferencedAssociation(order, query);
        return new OrderSpecifier(order.isAscending() ? Order.ASC : Order.DESC, property);
    }

    private Expression<?> createExpressionAndPotentionallyAddLeftJoinForReferencedAssociation(Sort.Order order, JPQLQuery query) {
        Assert.notNull((Object)order, (String)"Order must not be null!");
        Assert.notNull((Object)query, (String)"JPQLQuery must not be null!");
        if (!order.getProperty().contains(".")) {
            return order.isIgnoreCase() ? this.builder.getString(order.getProperty()).lower() : this.builder.get(order.getProperty());
        }
        EntityType entitytype = this.em.getMetamodel().entity(this.builder.getType());
        LinkedHashSet combinedAttributes = new LinkedHashSet();
        combinedAttributes.addAll(entitytype.getSingularAttributes());
        combinedAttributes.addAll(entitytype.getPluralAttributes());
        for (Attribute attribute : combinedAttributes) {
            if (!order.getProperty().startsWith(attribute.getName() + ".")) continue;
            switch (attribute.getPersistentAttributeType()) {
                case EMBEDDED: {
                    return this.builder.get(order.getProperty());
                }
            }
            return this.createLeftJoinForAttributeInOrderBy(attribute, order, query);
        }
        throw new IllegalArgumentException(String.format("Could not create property expression for %s", order.getProperty()));
    }

    private Expression<?> createLeftJoinForAttributeInOrderBy(Attribute<?, ?> parentAttribute, Sort.Order order, JPQLQuery query) {
        Assert.notNull(parentAttribute, (String)"Attribute must not be null!");
        Assert.notNull((Object)order, (String)"Order must not be null!");
        Assert.notNull((Object)query, (String)"Query must not be null!");
        EntityPathBase associationPathRoot = new EntityPathBase(parentAttribute.getJavaType(), parentAttribute.getName());
        query.leftJoin((EntityPath)this.builder.get(parentAttribute.getName()), (Path)associationPathRoot);
        PathBuilder attributePathBuilder = new PathBuilder(parentAttribute.getJavaType(), associationPathRoot.getMetadata());
        String nestedAttributePath = order.getProperty().substring(parentAttribute.getName().length() + 1);
        return order.isIgnoreCase() ? attributePathBuilder.getString(nestedAttributePath).lower() : attributePathBuilder.get(nestedAttributePath);
    }
}

