/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.path.PathBuilder;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.Jpa21Utils;
import org.springframework.data.jpa.repository.query.JpaEntityGraph;
import org.springframework.data.jpa.repository.support.CrudMethodMetadata;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.Querydsl;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.QSort;
import org.springframework.data.querydsl.QueryDslPredicateExecutor;
import org.springframework.data.querydsl.SimpleEntityPathResolver;

public class QueryDslJpaRepository<T, ID extends Serializable>
extends SimpleJpaRepository<T, ID>
implements QueryDslPredicateExecutor<T> {
    private static final EntityPathResolver DEFAULT_ENTITY_PATH_RESOLVER = SimpleEntityPathResolver.INSTANCE;
    private final EntityPath<T> path;
    private final PathBuilder<T> builder;
    private final Querydsl querydsl;
    private final EntityManager em;

    public QueryDslJpaRepository(JpaEntityInformation<T, ID> entityInformation, EntityManager entityManager) {
        this(entityInformation, entityManager, DEFAULT_ENTITY_PATH_RESOLVER);
    }

    public QueryDslJpaRepository(JpaEntityInformation<T, ID> entityInformation, EntityManager entityManager, EntityPathResolver resolver) {
        super(entityInformation, entityManager);
        this.em = entityManager;
        this.path = resolver.createPath(entityInformation.getJavaType());
        this.builder = new PathBuilder(this.path.getType(), this.path.getMetadata());
        this.querydsl = new Querydsl(entityManager, this.builder);
    }

    @Override
    public T findOne(Predicate predicate) {
        return (T)this.createQuery(predicate).uniqueResult(this.path);
    }

    public List<T> findAll(Predicate predicate) {
        return this.createQuery(predicate).list(this.path);
    }

    public List<T> findAll(Predicate predicate, OrderSpecifier<?> ... orders) {
        return this.executeSorted(this.createQuery(predicate), orders);
    }

    public List<T> findAll(Predicate predicate, Sort sort) {
        return this.executeSorted(this.createQuery(predicate), sort);
    }

    public List<T> findAll(OrderSpecifier<?> ... orders) {
        return this.executeSorted(this.createQuery(new Predicate[0]), orders);
    }

    public Page<T> findAll(Predicate predicate, Pageable pageable) {
        JPQLQuery countQuery = this.createQuery(predicate);
        JPQLQuery query = this.querydsl.applyPagination(pageable, this.createQuery(predicate));
        Long total = countQuery.count();
        List content = total > (long)pageable.getOffset() ? query.list(this.path) : Collections.emptyList();
        return new PageImpl(content, pageable, total.longValue());
    }

    public long count(Predicate predicate) {
        return this.createQuery(predicate).count();
    }

    @Override
    public boolean exists(Predicate predicate) {
        return this.createQuery(predicate).exists();
    }

    protected JPQLQuery createQuery(Predicate ... predicate) {
        JPAQuery query = (JPAQuery)this.querydsl.createQuery(this.path).where(predicate);
        CrudMethodMetadata metadata = this.getRepositoryMethodMetadata();
        if (metadata == null) {
            return query;
        }
        LockModeType type = metadata.getLockModeType();
        query = type == null ? query : (JPAQuery)query.setLockMode(type);
        for (Map.Entry<String, Object> hint : metadata.getQueryHints().entrySet()) {
            query.setHint(hint.getKey(), hint.getValue());
        }
        JpaEntityGraph jpaEntityGraph = metadata.getEntityGraph();
        if (jpaEntityGraph == null) {
            return query;
        }
        EntityGraph<?> entityGraph = Jpa21Utils.tryGetFetchGraph(this.em, jpaEntityGraph);
        if (entityGraph == null) {
            return query;
        }
        query.setHint(jpaEntityGraph.getType().getKey(), entityGraph);
        return query;
    }

    private List<T> executeSorted(JPQLQuery query, OrderSpecifier<?> ... orders) {
        return this.executeSorted(query, (Sort)new QSort(orders));
    }

    private List<T> executeSorted(JPQLQuery query, Sort sort) {
        return this.querydsl.applySorting(sort, query).list(this.path);
    }
}

