/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import java.io.Serializable;
import java.util.Optional;
import javax.persistence.EntityManager;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.provider.QueryExtractor;
import org.springframework.data.jpa.repository.query.JpaQueryLookupStrategy;
import org.springframework.data.jpa.repository.support.CrudMethodMetadataPostProcessor;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.JpaEntityInformationSupport;
import org.springframework.data.jpa.repository.support.QuerydslJpaRepository;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.querydsl.QuerydslUtils;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.util.Assert;

public class JpaRepositoryFactory
extends RepositoryFactorySupport {
    private final EntityManager entityManager;
    private final QueryExtractor extractor;
    private final CrudMethodMetadataPostProcessor crudMethodMetadataPostProcessor;

    public JpaRepositoryFactory(EntityManager entityManager) {
        Assert.notNull((Object)entityManager, (String)"EntityManager must not be null!");
        this.entityManager = entityManager;
        this.extractor = PersistenceProvider.fromEntityManager(entityManager);
        this.crudMethodMetadataPostProcessor = new CrudMethodMetadataPostProcessor();
        this.addRepositoryProxyPostProcessor(this.crudMethodMetadataPostProcessor);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        super.setBeanClassLoader(classLoader);
        this.crudMethodMetadataPostProcessor.setBeanClassLoader(classLoader);
    }

    protected Object getTargetRepository(RepositoryInformation information) {
        SimpleJpaRepository<?, ?> repository = this.getTargetRepository(information, this.entityManager);
        repository.setRepositoryMethodMetadata(this.crudMethodMetadataPostProcessor.getCrudMethodMetadata());
        return repository;
    }

    protected <T, ID extends Serializable> SimpleJpaRepository<?, ?> getTargetRepository(RepositoryInformation information, EntityManager entityManager) {
        EntityInformation entityInformation = this.getEntityInformation(information.getDomainType());
        return (SimpleJpaRepository)this.getTargetRepositoryViaReflection(information, new Object[]{entityInformation, entityManager});
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        if (this.isQueryDslExecutor(metadata.getRepositoryInterface())) {
            return QuerydslJpaRepository.class;
        }
        return SimpleJpaRepository.class;
    }

    private boolean isQueryDslExecutor(Class<?> repositoryInterface) {
        return QuerydslUtils.QUERY_DSL_PRESENT && QuerydslPredicateExecutor.class.isAssignableFrom(repositoryInterface);
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(QueryLookupStrategy.Key key, EvaluationContextProvider evaluationContextProvider) {
        return Optional.of(JpaQueryLookupStrategy.create(this.entityManager, key, this.extractor, evaluationContextProvider));
    }

    public <T, ID> JpaEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        return JpaEntityInformationSupport.getEntityInformation(domainClass, this.entityManager);
    }
}

