/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import com.querydsl.core.QueryModifiers;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.jpa.JPQLSerializer;
import com.querydsl.jpa.JPQLTemplates;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUtil;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.Tuple;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.data.jpa.repository.support.JakartaTuple;

class SpringDataJpaQuery<T>
extends JPAQuery<T> {
    public SpringDataJpaQuery(EntityManager em) {
        super(em);
    }

    public SpringDataJpaQuery(EntityManager em, JPQLTemplates templates) {
        super(em, templates);
    }

    protected Query createQuery(@Nullable QueryModifiers modifiers, boolean forCount) {
        JPQLSerializer serializer = this.serialize(forCount);
        String queryString = serializer.toString();
        this.logQuery(queryString);
        Query query = this.getMetadata().getProjection() instanceof JakartaTuple ? this.entityManager.createQuery(queryString, Tuple.class) : this.entityManager.createQuery(queryString);
        JPAUtil.setConstants((Query)query, (List)serializer.getConstants(), (Map)this.getMetadata().getParams());
        if (modifiers != null && modifiers.isRestricting()) {
            Integer limit = modifiers.getLimitAsInteger();
            Integer offset = modifiers.getOffsetAsInteger();
            if (limit != null) {
                query.setMaxResults(limit.intValue());
            }
            if (offset != null) {
                query.setFirstResult(offset.intValue());
            }
        }
        if (this.lockMode != null) {
            query.setLockMode(this.lockMode);
        }
        if (this.flushMode != null) {
            query.setFlushMode(this.flushMode);
        }
        for (Map.Entry entry : this.hints.entrySet()) {
            Object v = entry.getValue();
            if (v instanceof Collection) {
                Collection c = (Collection)v;
                c.forEach(value -> {
                    Query query2 = query.setHint((String)entry.getKey(), value);
                });
                continue;
            }
            query.setHint((String)entry.getKey(), entry.getValue());
        }
        Expression projection = this.getMetadata().getProjection();
        this.projection = null;
        if (!forCount && projection instanceof FactoryExpression && !this.queryHandler.transform(query, (FactoryExpression)projection)) {
            this.projection = (FactoryExpression)projection;
        }
        return query;
    }
}

