/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.BitSet;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.JpaParametersParameterAccessor;
import org.springframework.data.jpa.repository.query.JpqlQueryCreator;
import org.springframework.util.ObjectUtils;

class PartTreeQueryCache {
    private final Map<CacheKey, JpqlQueryCreator> cache = Collections.synchronizedMap(new LinkedHashMap<CacheKey, JpqlQueryCreator>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<CacheKey, JpqlQueryCreator> eldest) {
            return this.size() > 256;
        }
    });

    PartTreeQueryCache() {
    }

    @Nullable
    JpqlQueryCreator get(Sort sort, JpaParametersParameterAccessor accessor) {
        return this.cache.get(CacheKey.of(sort, accessor));
    }

    @Nullable
    JpqlQueryCreator put(Sort sort, JpaParametersParameterAccessor accessor, JpqlQueryCreator creator) {
        return this.cache.put(CacheKey.of(sort, accessor), creator);
    }

    static class CacheKey {
        private final Sort sort;
        private final BitSet params;

        public CacheKey(Sort sort, BitSet params) {
            this.sort = sort;
            this.params = params;
        }

        static CacheKey of(Sort sort, JpaParametersParameterAccessor accessor) {
            Object[] values = accessor.getValues();
            if (ObjectUtils.isEmpty((Object[])values)) {
                return new CacheKey(sort, new BitSet());
            }
            return new CacheKey(sort, CacheKey.toNullableMap(values));
        }

        static BitSet toNullableMap(Object[] args) {
            BitSet bitSet = new BitSet(args.length);
            int i = 0;
            while (i < args.length) {
                bitSet.set(i, args[i] != null);
                ++i;
            }
            return bitSet;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.sort.equals((Object)cacheKey.sort) && this.params.equals(cacheKey.params);
        }

        public int hashCode() {
            return Objects.hash(this.sort, this.params);
        }
    }
}

