/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.Tree;
import org.jspecify.annotations.Nullable;
import org.springframework.data.jpa.repository.query.EmptyQueryTokenStream;
import org.springframework.data.jpa.repository.query.QueryRenderer;
import org.springframework.data.jpa.repository.query.QueryToken;
import org.springframework.data.jpa.repository.query.QueryTokens;
import org.springframework.data.util.Streamable;
import org.springframework.util.CollectionUtils;

interface QueryTokenStream
extends Streamable<QueryToken> {
    public static QueryTokenStream empty() {
        return EmptyQueryTokenStream.INSTANCE;
    }

    public static <T> QueryTokenStream concat(Collection<T> elements, Function<T, QueryTokenStream> visitor, QueryToken separator) {
        return QueryTokenStream.concat(elements, visitor, QueryRenderer::inline, separator);
    }

    public static <T> QueryTokenStream concatExpressions(Collection<T> elements, Function<T, QueryTokenStream> visitor, QueryToken separator) {
        return QueryTokenStream.concat(elements, visitor, QueryRenderer::ofExpression, separator);
    }

    public static <T> QueryTokenStream concatExpressions(Collection<T> elements, Function<T, QueryTokenStream> visitor) {
        if (CollectionUtils.isEmpty(elements)) {
            return QueryTokenStream.empty();
        }
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        for (T child : elements) {
            if (child instanceof TerminalNode) {
                TerminalNode tn = (TerminalNode)child;
                builder.append(QueryTokens.expression(tn));
                continue;
            }
            builder.appendExpression(visitor.apply(child));
        }
        return builder.build();
    }

    public static QueryTokenStream concatExpressions(Tree elements, Function<? super ParseTree, QueryTokenStream> visitor) {
        int childCount = elements.getChildCount();
        if (childCount == 0) {
            return QueryTokenStream.empty();
        }
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        int i = 0;
        while (i < childCount) {
            Tree child = elements.getChild(i);
            if (child instanceof TerminalNode) {
                TerminalNode tn = (TerminalNode)child;
                builder.append(QueryTokens.expression(tn));
            } else if (child instanceof ParseTree) {
                ParseTree pt = (ParseTree)child;
                builder.appendExpression(visitor.apply((ParseTree)pt));
            } else {
                throw new IllegalArgumentException("Unsupported child type: " + String.valueOf(child));
            }
            ++i;
        }
        return builder.build();
    }

    public static <T> QueryTokenStream concat(Collection<T> elements, Function<T, QueryTokenStream> visitor, Function<QueryTokenStream, QueryTokenStream> postProcess, QueryToken separator) {
        QueryRenderer.QueryRendererBuilder builder = null;
        QueryTokenStream firstElement = null;
        for (T element : elements) {
            QueryTokenStream tokenStream = postProcess.apply(visitor.apply(element));
            if (firstElement == null) {
                firstElement = tokenStream;
                continue;
            }
            if (builder == null) {
                builder = QueryRenderer.builder();
                builder.append(firstElement);
            }
            if (!builder.isEmpty()) {
                builder.append(separator);
            }
            builder.append(tokenStream);
        }
        if (builder != null) {
            return builder;
        }
        if (firstElement != null) {
            return firstElement;
        }
        return QueryTokenStream.empty();
    }

    public static QueryTokenStream group(QueryTokenStream nested) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline(nested);
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder.build();
    }

    public static QueryTokenStream ofFunction(TerminalNode functionName, QueryTokenStream arguments) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(functionName));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline(arguments);
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder.build();
    }

    @Nullable
    default public QueryToken getFirst() {
        Iterator it = this.iterator();
        return it.hasNext() ? (QueryToken)it.next() : null;
    }

    default public QueryToken getRequiredFirst() {
        QueryToken first = this.getFirst();
        if (first == null) {
            throw new NoSuchElementException("No token in the stream");
        }
        return first;
    }

    @Nullable
    default public QueryToken getLast() {
        return (QueryToken)CollectionUtils.lastElement((List)this.toList());
    }

    default public QueryToken getRequiredLast() {
        QueryToken last = this.getLast();
        if (last == null) {
            throw new NoSuchElementException("No token in the stream");
        }
        return last;
    }

    public boolean isExpression();

    public int size();

    public boolean isEmpty();
}

