/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.authentication.UserCredentials;
import org.springframework.data.mongodb.config.ParsingUtils;
import org.springframework.data.mongodb.core.MongoFactoryBean;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class MongoDbFactoryParser
extends AbstractBeanDefinitionParser {
    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = element.getAttribute("id");
        if (!StringUtils.hasText((String)id)) {
            id = "mongoDbFactory";
        }
        return id;
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        String dbname;
        String mongoRef = element.getAttribute("mongo-ref");
        if (!StringUtils.hasText((String)mongoRef)) {
            mongoRef = this.registerMongoBeanDefinition(element, parserContext);
        }
        if (!StringUtils.hasText((String)(dbname = element.getAttribute("dbname")))) {
            dbname = "db";
        }
        BeanDefinitionBuilder dbFactoryBuilder = BeanDefinitionBuilder.genericBeanDefinition(SimpleMongoDbFactory.class);
        dbFactoryBuilder.addConstructorArgValue((Object)new RuntimeBeanReference(mongoRef));
        dbFactoryBuilder.addConstructorArgValue((Object)dbname);
        BeanDefinition userCredentials = this.getUserCredentialsBeanDefinition(element);
        if (userCredentials != null) {
            dbFactoryBuilder.addConstructorArgValue((Object)userCredentials);
        }
        ParsingUtils.setPropertyValue(element, dbFactoryBuilder, "write-concern", "writeConcern");
        return dbFactoryBuilder.getBeanDefinition();
    }

    private String registerMongoBeanDefinition(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder mongoBuilder = BeanDefinitionBuilder.genericBeanDefinition(MongoFactoryBean.class);
        ParsingUtils.setPropertyValue(element, mongoBuilder, "host");
        ParsingUtils.setPropertyValue(element, mongoBuilder, "port");
        return BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)mongoBuilder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
    }

    private BeanDefinition getUserCredentialsBeanDefinition(Element element) {
        String username = element.getAttribute("username");
        String password = element.getAttribute("password");
        if (!StringUtils.hasText((String)username) && !StringUtils.hasText((String)password)) {
            return null;
        }
        BeanDefinitionBuilder userCredentialsBuilder = BeanDefinitionBuilder.genericBeanDefinition(UserCredentials.class);
        userCredentialsBuilder.addConstructorArgValue((Object)(StringUtils.hasText((String)username) ? username : null));
        userCredentialsBuilder.addConstructorArgValue((Object)(StringUtils.hasText((String)password) ? password : null));
        return userCredentialsBuilder.getBeanDefinition();
    }
}

