/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import com.mongodb.ServerAddress;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.mongodb.core.MongoOptionsFactoryBean;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

abstract class ParsingUtils {
    ParsingUtils() {
    }

    static boolean parseReplicaSet(ParserContext parserContext, Element element, BeanDefinitionBuilder mongoBuilder) {
        String replicaSetString = element.getAttribute("replica-set");
        if (StringUtils.hasText((String)replicaSetString)) {
            String[] replicaSetStringArray;
            ManagedList serverAddresses = new ManagedList();
            for (String element2 : replicaSetStringArray = StringUtils.commaDelimitedListToStringArray((String)replicaSetString)) {
                String[] hostAndPort = StringUtils.delimitedListToStringArray((String)element2, (String)":");
                BeanDefinitionBuilder defBuilder = BeanDefinitionBuilder.genericBeanDefinition(ServerAddress.class);
                defBuilder.addConstructorArgValue((Object)hostAndPort[0]);
                defBuilder.addConstructorArgValue((Object)hostAndPort[1]);
                serverAddresses.add((Object)defBuilder.getBeanDefinition());
            }
            if (!serverAddresses.isEmpty()) {
                mongoBuilder.addPropertyValue("replicaSetSeeds", (Object)serverAddresses);
            }
        }
        return true;
    }

    static boolean parseMongoOptions(ParserContext parserContext, Element element, BeanDefinitionBuilder mongoBuilder) {
        Element optionsElement = DomUtils.getChildElementByTagName((Element)element, (String)"options");
        if (optionsElement == null) {
            return false;
        }
        BeanDefinitionBuilder optionsDefBuilder = BeanDefinitionBuilder.genericBeanDefinition(MongoOptionsFactoryBean.class);
        ParsingUtils.setPropertyValue(optionsElement, optionsDefBuilder, "connections-per-host", "connectionsPerHost");
        ParsingUtils.setPropertyValue(optionsElement, optionsDefBuilder, "threads-allowed-to-block-for-connection-multiplier", "threadsAllowedToBlockForConnectionMultiplier");
        ParsingUtils.setPropertyValue(optionsElement, optionsDefBuilder, "max-wait-time", "maxWaitTime");
        ParsingUtils.setPropertyValue(optionsElement, optionsDefBuilder, "connect-timeout", "connectTimeout");
        ParsingUtils.setPropertyValue(optionsElement, optionsDefBuilder, "socket-timeout", "socketTimeout");
        ParsingUtils.setPropertyValue(optionsElement, optionsDefBuilder, "socket-keep-alive", "socketKeepAlive");
        ParsingUtils.setPropertyValue(optionsElement, optionsDefBuilder, "auto-connect-retry", "autoConnectRetry");
        ParsingUtils.setPropertyValue(optionsElement, optionsDefBuilder, "write-number", "writeNumber");
        ParsingUtils.setPropertyValue(optionsElement, optionsDefBuilder, "write-timeout", "writeTimeout");
        ParsingUtils.setPropertyValue(optionsElement, optionsDefBuilder, "write-fsync", "writeFsync");
        ParsingUtils.setPropertyValue(optionsElement, optionsDefBuilder, "slave-ok", "slaveOk");
        mongoBuilder.addPropertyValue("mongoOptions", (Object)optionsDefBuilder.getBeanDefinition());
        return true;
    }

    static void setPropertyValue(Element element, BeanDefinitionBuilder builder, String attrName, String propertyName) {
        String attr = element.getAttribute(attrName);
        if (StringUtils.hasText((String)attr)) {
            builder.addPropertyValue(propertyName, (Object)attr);
        }
    }

    static void setPropertyValue(Element element, BeanDefinitionBuilder builder, String attrName) {
        String attr = element.getAttribute(attrName);
        if (StringUtils.hasText((String)attr)) {
            builder.addPropertyValue(attrName, (Object)attr);
        }
    }
}

