/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.BasicDBList;
import com.mongodb.DBObject;
import java.util.List;
import org.springframework.data.mongodb.core.convert.TypeMapper;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTypeMapper
implements TypeMapper {
    public static final String DEFAULT_TYPE_KEY = "_class";
    private static final TypeInformation<List> LIST_TYPE_INFORMATION = ClassTypeInformation.from(List.class);
    private String typeKey = "_class";

    public void setTypeKey(String typeKey) {
        this.typeKey = typeKey;
    }

    @Override
    public boolean isTypeKey(String key) {
        return this.typeKey == null ? false : this.typeKey.equals(key);
    }

    @Override
    public TypeInformation<?> readType(DBObject dbObject) {
        if (dbObject instanceof BasicDBList) {
            return LIST_TYPE_INFORMATION;
        }
        if (this.typeKey == null) {
            return null;
        }
        Object classToBeUsed = dbObject.get(this.typeKey);
        if (classToBeUsed == null) {
            return null;
        }
        return this.getTypeInformation(classToBeUsed.toString());
    }

    @Override
    public void writeType(Class<?> type, DBObject dbObject) {
        this.writeType(ClassTypeInformation.from(type), dbObject);
    }

    @Override
    public void writeType(TypeInformation<?> info, DBObject dbObject) {
        Assert.notNull(info);
        if (this.typeKey == null) {
            return;
        }
        String string = this.getTypeString(info);
        if (string != null) {
            dbObject.put(this.typeKey, (Object)this.getTypeString(info));
        }
    }

    protected String getTypeString(TypeInformation<?> typeInformation) {
        return typeInformation.getType().getName();
    }

    protected TypeInformation<?> getTypeInformation(String value) {
        if (!StringUtils.hasText((String)value)) {
            return null;
        }
        try {
            return ClassTypeInformation.from((Class)ClassUtils.forName((String)value, null));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

