/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.mongodb.core.convert.MongoPropertyDescriptors;
import org.springframework.util.Assert;

class MongoBeanWrapper {
    private final ConfigurablePropertyAccessor accessor;
    private final MongoPropertyDescriptors descriptors;
    private final boolean fieldAccess;

    public MongoBeanWrapper(Object target, ConversionService conversionService, boolean fieldAccess) {
        Assert.notNull((Object)target);
        Assert.notNull((Object)conversionService);
        this.fieldAccess = fieldAccess;
        this.accessor = fieldAccess ? PropertyAccessorFactory.forDirectFieldAccess((Object)target) : PropertyAccessorFactory.forBeanPropertyAccess((Object)target);
        this.accessor.setConversionService(conversionService);
        this.descriptors = new MongoPropertyDescriptors(target.getClass());
    }

    public MongoPropertyDescriptors getDescriptors() {
        return this.descriptors;
    }

    public Object getValue(MongoPropertyDescriptors.MongoPropertyDescriptor descriptor) {
        Assert.notNull((Object)descriptor);
        return this.accessor.getPropertyValue(descriptor.getName());
    }

    public void setValue(MongoPropertyDescriptors.MongoPropertyDescriptor descriptor, Object value) {
        block2: {
            Assert.notNull((Object)descriptor);
            try {
                this.accessor.setPropertyValue(descriptor.getName(), value);
            }
            catch (NotWritablePropertyException e) {
                if (this.fieldAccess) break block2;
                throw e;
            }
        }
    }
}

